/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.geo.location;

import de.digitalcollections.model.geo.CoordinateLocation;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.NamedEntity;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocationType;
import de.digitalcollections.model.text.LocalizedText;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class GeoLocation
extends Entity
implements NamedEntity {
    protected CoordinateLocation coordinateLocation;
    protected GeoLocationType geoLocationType;
    protected LocalizedText name;
    protected Set<Locale> nameLocalesOfOriginalScripts;

    public GeoLocation() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)obj;
        return this == other || super.equals(obj) && Objects.equals(this.coordinateLocation, other.coordinateLocation) && this.geoLocationType == other.geoLocationType && Objects.equals(this.name, other.name) && Objects.equals(this.nameLocalesOfOriginalScripts, other.nameLocalesOfOriginalScripts);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(new Object[]{this.coordinateLocation, this.geoLocationType, this.name, this.nameLocalesOfOriginalScripts}) + 18;
    }

    public CoordinateLocation getCoordinateLocation() {
        return this.coordinateLocation;
    }

    public GeoLocationType getGeoLocationType() {
        return this.geoLocationType;
    }

    public Double getLatitude() {
        if (this.getCoordinateLocation() == null) {
            return null;
        }
        return this.getCoordinateLocation().getLatitude();
    }

    public Double getLongitude() {
        if (this.getCoordinateLocation() == null) {
            return null;
        }
        return this.getCoordinateLocation().getLongitude();
    }

    @Override
    public LocalizedText getName() {
        return this.name;
    }

    @Override
    public Set<Locale> getNameLocalesOfOriginalScripts() {
        return this.nameLocalesOfOriginalScripts;
    }

    @Override
    protected void init() {
        super.init();
        this.geoLocationType = GeoLocationType.GEOLOCATION;
        if (this.nameLocalesOfOriginalScripts == null) {
            this.nameLocalesOfOriginalScripts = new HashSet<Locale>(0);
        }
    }

    public void setCoordinateLocation(CoordinateLocation coordinateLocation) {
        this.coordinateLocation = coordinateLocation;
    }

    public void setGeoLocationType(GeoLocationType geoLocationType) {
        this.geoLocationType = geoLocationType;
    }

    @Override
    public void setName(LocalizedText name) {
        this.name = name;
    }

    @Override
    public void setNameLocalesOfOriginalScripts(Set<Locale> localesOfOriginalScripts) {
        this.nameLocalesOfOriginalScripts = localesOfOriginalScripts;
    }

    public String toString() {
        return "GeoLocation [coordinateLocation=" + this.coordinateLocation + ", geoLocationType=" + this.geoLocationType + ", name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + ", created=" + this.created + ", customAttributes=" + this.customAttributes + ", description=" + this.description + ", identifiableObjectType=" + this.identifiableObjectType + ", identifiers=" + this.identifiers + ", label=" + this.label + ", lastModified=" + this.lastModified + ", localizedUrlAliases=" + this.localizedUrlAliases + ", navDate=" + this.navDate + ", notes=" + this.notes + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", refId=" + this.refId + ", tags=" + this.tags + ", type=" + this.type + ", uuid=" + this.uuid + "]";
    }

    protected GeoLocation(GeoLocationBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.coordinateLocation = b.coordinateLocation;
        this.geoLocationType = b.geoLocationType;
        this.name = b.name;
        this.nameLocalesOfOriginalScripts = b.nameLocalesOfOriginalScripts;
    }

    public static GeoLocationBuilder<?, ?> builder() {
        return new GeoLocationBuilderImpl();
    }

    public static abstract class GeoLocationBuilder<C extends GeoLocation, B extends GeoLocationBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private CoordinateLocation coordinateLocation;
        private GeoLocationType geoLocationType;
        private LocalizedText name;
        private Set<Locale> nameLocalesOfOriginalScripts;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((GeoLocation)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B coordinateLocation(CoordinateLocation coordinateLocation) {
            this.coordinateLocation = coordinateLocation;
            return (B)this.self();
        }

        public B geoLocationType(GeoLocationType geoLocationType) {
            this.geoLocationType = geoLocationType;
            return (B)this.self();
        }

        public B name(LocalizedText name) {
            this.name = name;
            return (B)this.self();
        }

        public B nameLocalesOfOriginalScripts(Set<Locale> nameLocalesOfOriginalScripts) {
            this.nameLocalesOfOriginalScripts = nameLocalesOfOriginalScripts;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "GeoLocation.GeoLocationBuilder(super=" + super.toString() + ", coordinateLocation=" + this.coordinateLocation + ", geoLocationType=" + this.geoLocationType + ", name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + ")";
        }
    }

    private static final class GeoLocationBuilderImpl
    extends GeoLocationBuilder<GeoLocation, GeoLocationBuilderImpl> {
        private GeoLocationBuilderImpl() {
        }

        @Override
        protected GeoLocationBuilderImpl self() {
            return this;
        }

        @Override
        public GeoLocation prebuild() {
            return new GeoLocation(this);
        }
    }
}

