/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.agent;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.NamedEntity;
import de.digitalcollections.model.text.LocalizedText;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class Agent
extends Entity
implements NamedEntity {
    protected LocalizedText name;
    protected Set<Locale> nameLocalesOfOriginalScripts;

    public Agent() {
    }

    @Override
    protected void init() {
        super.init();
        if (this.nameLocalesOfOriginalScripts == null) {
            this.nameLocalesOfOriginalScripts = new HashSet<Locale>(0);
        }
    }

    @Override
    public LocalizedText getName() {
        return this.name;
    }

    @Override
    public Set<Locale> getNameLocalesOfOriginalScripts() {
        return this.nameLocalesOfOriginalScripts;
    }

    @Override
    public void setName(LocalizedText name) {
        this.name = name;
    }

    @Override
    public void setNameLocalesOfOriginalScripts(Set<Locale> localesOfOriginalScripts) {
        this.nameLocalesOfOriginalScripts = localesOfOriginalScripts;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Agent)) {
            return false;
        }
        Agent other = (Agent)obj;
        return obj == this || super.equals(obj) && Objects.equals(this.name, other.name) && Objects.equals(this.nameLocalesOfOriginalScripts, other.nameLocalesOfOriginalScripts);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.name, this.nameLocalesOfOriginalScripts) + 93;
    }

    public String toString() {
        return "Agent [name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + ", notes=" + this.notes + ", description=" + this.description + ", identifiableObjectType=" + this.identifiableObjectType + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", tags=" + this.tags + ", type=" + this.type + ", created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + ", name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + "]";
    }

    protected Agent(AgentBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.name = b.name;
        this.nameLocalesOfOriginalScripts = b.nameLocalesOfOriginalScripts;
    }

    public static AgentBuilder<?, ?> builder() {
        return new AgentBuilderImpl();
    }

    public static abstract class AgentBuilder<C extends Agent, B extends AgentBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private LocalizedText name;
        private Set<Locale> nameLocalesOfOriginalScripts;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Agent)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B addName(Locale locale, String name) {
            if (this.name == null) {
                this.name = new LocalizedText(locale, name);
            } else {
                this.name.put(locale, name);
            }
            return (B)this.self();
        }

        public B addName(String name) {
            if (this.name == null) {
                this.name = new LocalizedText(Locale.ROOT, name);
            } else {
                this.name.put(Locale.ROOT, name);
            }
            return (B)this.self();
        }

        public B name(LocalizedText name) {
            this.name = name;
            return (B)this.self();
        }

        public B nameLocalesOfOriginalScripts(Set<Locale> nameLocalesOfOriginalScripts) {
            this.nameLocalesOfOriginalScripts = nameLocalesOfOriginalScripts;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Agent.AgentBuilder(super=" + super.toString() + ", name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + ")";
        }
    }

    private static final class AgentBuilderImpl
    extends AgentBuilder<Agent, AgentBuilderImpl> {
        private AgentBuilderImpl() {
        }

        @Override
        protected AgentBuilderImpl self() {
            return this;
        }

        @Override
        public Agent prebuild() {
            return new Agent(this);
        }
    }
}

