/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.INode;
import de.digitalcollections.model.identifiable.Node;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.util.ArrayList;
import java.util.List;

public class Topic
extends Entity
implements INode<Topic> {
    private List<Entity> entities;
    private List<FileResource> fileResources;
    private Node<Topic> node;

    public Topic() {
    }

    public Topic(List<Topic> children) {
        this();
        this.node.setChildren(children);
    }

    @Override
    public void addChild(Topic child) {
        this.node.addChild(child);
    }

    public void addEntity(Entity entity) {
        if (this.getEntities() == null) {
            this.setEntities(new ArrayList<Entity>(0));
        }
        this.getEntities().add(entity);
    }

    public void addFileResource(FileResource fileResource) {
        if (this.getFileResources() == null) {
            this.setFileResources(new ArrayList<FileResource>(0));
        }
        this.getFileResources().add(fileResource);
    }

    @Override
    public List<Topic> getChildren() {
        return this.node.getChildren();
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<FileResource> getFileResources() {
        return this.fileResources;
    }

    @Override
    public Topic getParent() {
        return this.node.getParent();
    }

    @Override
    protected void init() {
        super.init();
        if (this.node == null) {
            this.node = new Node();
        }
        if (this.entities == null) {
            this.entities = new ArrayList<Entity>(0);
        }
        if (this.fileResources == null) {
            this.fileResources = new ArrayList<FileResource>(0);
        }
    }

    @Override
    public void setChildren(List<Topic> children) {
        this.node.setChildren(children);
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public void setFileResources(List<FileResource> fileResources) {
        this.fileResources = fileResources;
    }

    @Override
    public void setParent(Topic parent) {
        this.node.setParent(parent);
    }

    protected Topic(TopicBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.entities = b.entities;
        this.fileResources = b.fileResources;
        this.node = b.node;
    }

    public static TopicBuilder<?, ?> builder() {
        return new TopicBuilderImpl();
    }

    public static abstract class TopicBuilder<C extends Topic, B extends TopicBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private List<Entity> entities;
        private List<FileResource> fileResources;
        private Node<Topic> node;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Topic)c).init();
            return (C)c;
        }

        public B entities(List<Entity> entities) {
            this.entities = entities;
            return (B)this.self();
        }

        public B fileResources(List<FileResource> fileResources) {
            this.fileResources = fileResources;
            return (B)this.self();
        }

        public B node(Node<Topic> node) {
            this.node = node;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Topic.TopicBuilder(super=" + super.toString() + ", entities=" + this.entities + ", fileResources=" + this.fileResources + ", node=" + this.node + ")";
        }
    }

    private static final class TopicBuilderImpl
    extends TopicBuilder<Topic, TopicBuilderImpl> {
        private TopicBuilderImpl() {
        }

        @Override
        protected TopicBuilderImpl self() {
            return this;
        }

        @Override
        public Topic prebuild() {
            return new Topic(this);
        }
    }
}

