/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.NamedEntity;
import de.digitalcollections.model.text.LocalizedText;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class Event
extends Entity
implements NamedEntity {
    protected LocalizedText name;
    protected Set<Locale> nameLocalesOfOriginalScripts;

    public Event() {
    }

    @Override
    protected void init() {
        super.init();
        if (this.nameLocalesOfOriginalScripts == null) {
            this.nameLocalesOfOriginalScripts = new HashSet<Locale>(0);
        }
    }

    @Override
    public LocalizedText getName() {
        return this.name;
    }

    @Override
    public Set<Locale> getNameLocalesOfOriginalScripts() {
        return this.nameLocalesOfOriginalScripts;
    }

    @Override
    public void setName(LocalizedText name) {
        this.name = name;
    }

    @Override
    public void setNameLocalesOfOriginalScripts(Set<Locale> localesOfOriginalScripts) {
        this.nameLocalesOfOriginalScripts = localesOfOriginalScripts;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return obj == this || super.equals(obj) && Objects.equals(this.name, other.name) && Objects.equals(this.nameLocalesOfOriginalScripts, other.nameLocalesOfOriginalScripts);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.name, this.nameLocalesOfOriginalScripts) + 93;
    }

    public String toString() {
        return "Event [name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + ", notes=" + this.notes + ", description=" + this.description + ", identifiableObjectType=" + this.identifiableObjectType + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", tags=" + this.tags + ", type=" + this.type + ", created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + ", name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + "]";
    }

    protected Event(EventBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.name = b.name;
        this.nameLocalesOfOriginalScripts = b.nameLocalesOfOriginalScripts;
    }

    public static EventBuilder<?, ?> builder() {
        return new EventBuilderImpl();
    }

    public static abstract class EventBuilder<C extends Event, B extends EventBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private LocalizedText name;
        private Set<Locale> nameLocalesOfOriginalScripts;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Event)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B addName(Locale locale, String name) {
            if (this.name == null) {
                this.name = new LocalizedText(locale, name);
            } else {
                this.name.put(locale, name);
            }
            return (B)this.self();
        }

        public B addName(String name) {
            if (this.name == null) {
                this.name = new LocalizedText(Locale.ROOT, name);
            } else {
                this.name.put(Locale.ROOT, name);
            }
            return (B)this.self();
        }

        public B name(LocalizedText name) {
            this.name = name;
            return (B)this.self();
        }

        public B nameLocalesOfOriginalScripts(Set<Locale> nameLocalesOfOriginalScripts) {
            this.nameLocalesOfOriginalScripts = nameLocalesOfOriginalScripts;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Event.EventBuilder(super=" + super.toString() + ", name=" + this.name + ", nameLocalesOfOriginalScripts=" + this.nameLocalesOfOriginalScripts + ")";
        }
    }

    private static final class EventBuilderImpl
    extends EventBuilder<Event, EventBuilderImpl> {
        private EventBuilderImpl() {
        }

        @Override
        protected EventBuilderImpl self() {
            return this;
        }

        @Override
        public Event prebuild() {
            return new Event(this);
        }
    }
}

