/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.entity.CustomAttributes;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Entity
extends Identifiable {
    protected CustomAttributes customAttributes;
    protected LocalDate navDate;
    protected long refId;
    protected List<LocalizedStructuredContent> notes;

    public Entity() {
    }

    public void addNotes(LocalizedStructuredContent ... notesToAdd) {
        if (this.notes == null) {
            this.notes = new ArrayList<LocalizedStructuredContent>();
        }
        Arrays.stream(notesToAdd).forEachOrdered(note -> this.notes.add((LocalizedStructuredContent)note));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)o;
        return super.equals(o) && this.refId == entity.refId && Objects.equals(this.customAttributes, entity.customAttributes) && Objects.equals(this.navDate, entity.navDate) && Objects.equals(this.notes, entity.notes);
    }

    public Object getCustomAttribute(String attributeName) {
        if (this.hasCustomAttribute(attributeName)) {
            return this.getCustomAttributes().get(attributeName);
        }
        return null;
    }

    public CustomAttributes getCustomAttributes() {
        return this.customAttributes;
    }

    @Deprecated(forRemoval=true, since="10.0.0")
    public EntityType getEntityType() {
        if (IdentifiableType.RESOURCE == this.getType()) {
            return null;
        }
        switch (this.identifiableObjectType) {
            case CANYON: 
            case CAVE: 
            case CONTINENT: 
            case COUNTRY: 
            case CREEK: 
            case GEO_LOCATION: 
            case HUMAN_SETTLEMENT: 
            case LAKE: 
            case MOUNTAIN: 
            case OCEAN: 
            case RIVER: 
            case SEA: 
            case STILL_WATERS: 
            case VALLEY: {
                return EntityType.GEOLOCATION;
            }
        }
        return EntityType.valueOf(this.getIdentifiableObjectType().toString());
    }

    public LocalDate getNavDate() {
        return this.navDate;
    }

    public List<LocalizedStructuredContent> getNotes() {
        return this.notes;
    }

    public long getRefId() {
        return this.refId;
    }

    private boolean hasCustomAttribute(String attributeName) {
        return this.customAttributes != null && this.customAttributes.containsKey(attributeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.customAttributes, this.navDate, this.notes, this.refId);
    }

    @Override
    protected void init() {
        super.init();
        this.type = IdentifiableType.ENTITY;
        if (this.notes == null) {
            this.notes = new ArrayList<LocalizedStructuredContent>(0);
        }
    }

    public void setCustomAttribute(String attributeName, Object attributeValue) {
        if (this.customAttributes == null) {
            this.customAttributes = new CustomAttributes();
        }
        this.customAttributes.put(attributeName, attributeValue);
    }

    public void setCustomAttributes(CustomAttributes customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setNavDate(LocalDate navDate) {
        this.navDate = navDate;
    }

    public void setNotes(List<LocalizedStructuredContent> notes) {
        this.notes = notes;
    }

    public void setRefId(long refId) {
        this.refId = refId;
    }

    protected Entity(EntityBuilder<?, ?> b) {
        super((Identifiable.IdentifiableBuilder<?, ?>)b);
        this.customAttributes = b.customAttributes;
        this.navDate = b.navDate;
        this.refId = b.refId;
        this.notes = b.notes;
    }

    public static EntityBuilder<?, ?> builder() {
        return new EntityBuilderImpl();
    }

    public static abstract class EntityBuilder<C extends Entity, B extends EntityBuilder<C, B>>
    extends Identifiable.IdentifiableBuilder<C, B> {
        private CustomAttributes customAttributes;
        private LocalDate navDate;
        private long refId;
        private List<LocalizedStructuredContent> notes;

        @Override
        public C build() {
            Identifiable c = this.prebuild();
            ((Entity)c).init();
            return (C)c;
        }

        public B customAttribute(String key, Object value) {
            if (this.customAttributes == null) {
                this.customAttributes = new CustomAttributes();
            }
            this.customAttributes.put(key, value);
            return (B)this.self();
        }

        public B navDate(String navDate) {
            this.navDate = LocalDate.parse(navDate);
            return (B)this.self();
        }

        public B note(LocalizedStructuredContent content) {
            if (this.notes == null) {
                this.notes = new ArrayList<LocalizedStructuredContent>();
            }
            this.notes.add(content);
            return (B)this.self();
        }

        public B customAttributes(CustomAttributes customAttributes) {
            this.customAttributes = customAttributes;
            return (B)this.self();
        }

        public B refId(long refId) {
            this.refId = refId;
            return (B)this.self();
        }

        public B notes(List<LocalizedStructuredContent> notes) {
            this.notes = notes;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Entity.EntityBuilder(super=" + super.toString() + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + ", notes=" + this.notes + ")";
        }
    }

    private static final class EntityBuilderImpl
    extends EntityBuilder<Entity, EntityBuilderImpl> {
        private EntityBuilderImpl() {
        }

        @Override
        protected EntityBuilderImpl self() {
            return this;
        }

        @Override
        public Entity prebuild() {
            return new Entity(this);
        }
    }
}

