/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;

public class Article
extends Entity {
    private List<Agent> creators;
    private LocalDate datePublished;
    private LocalizedStructuredContent text;
    private TimeValue timeValuePublished;

    public Article() {
    }

    public List<Agent> getCreators() {
        return this.creators;
    }

    public LocalDate getDatePublished() {
        return this.datePublished;
    }

    public LocalizedStructuredContent getText() {
        return this.text;
    }

    public TimeValue getTimeValuePublished() {
        return this.timeValuePublished;
    }

    @Override
    protected void init() {
        super.init();
        if (this.creators == null) {
            this.creators = new ArrayList<Agent>(0);
        }
    }

    public void setCreators(List<Agent> creators) {
        this.creators = creators;
    }

    public void setDatePublished(LocalDate datePublished) {
        this.datePublished = datePublished;
    }

    public void setText(LocalizedStructuredContent text) {
        this.text = text;
    }

    public void setTimeValuePublished(TimeValue timeValuePublished) {
        this.timeValuePublished = timeValuePublished;
    }

    protected Article(ArticleBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.creators = b.creators;
        this.datePublished = b.datePublished;
        this.text = b.text;
        this.timeValuePublished = b.timeValuePublished;
    }

    public static ArticleBuilder<?, ?> builder() {
        return new ArticleBuilderImpl();
    }

    public static abstract class ArticleBuilder<C extends Article, B extends ArticleBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private List<Agent> creators;
        private LocalDate datePublished;
        private LocalizedStructuredContent text;
        private TimeValue timeValuePublished;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Article)c).init();
            return (C)c;
        }

        public B creators(List<Agent> creators) {
            this.creators = creators;
            return (B)this.self();
        }

        public B datePublished(LocalDate datePublished) {
            this.datePublished = datePublished;
            return (B)this.self();
        }

        public B text(LocalizedStructuredContent text) {
            this.text = text;
            return (B)this.self();
        }

        public B timeValuePublished(TimeValue timeValuePublished) {
            this.timeValuePublished = timeValuePublished;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Article.ArticleBuilder(super=" + super.toString() + ", creators=" + this.creators + ", datePublished=" + this.datePublished + ", text=" + this.text + ", timeValuePublished=" + this.timeValuePublished + ")";
        }
    }

    private static final class ArticleBuilderImpl
    extends ArticleBuilder<Article, ArticleBuilderImpl> {
        private ArticleBuilderImpl() {
        }

        @Override
        protected ArticleBuilderImpl self() {
            return this;
        }

        @Override
        public Article prebuild() {
            return new Article(this);
        }
    }
}

