/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.alias;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.time.TimestampHelper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public class UrlAlias
extends UniqueObject {
    private LocalDateTime lastPublished;
    private boolean primary;
    private String slug;
    private Identifiable target;
    private Locale targetLanguage;
    private Website website;

    public UrlAlias() {
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UrlAlias)) {
            return false;
        }
        UrlAlias other = (UrlAlias)obj;
        return super.equals(obj) && Objects.equals(this.lastPublished, other.lastPublished) && this.primary == other.primary && Objects.equals(this.slug, other.slug) && Objects.equals(this.targetLanguage, other.targetLanguage) && Objects.equals(this.uuid, other.uuid) && Objects.equals(this.website != null ? this.website.getUuid() : null, other.website != null ? other.website.getUuid() : null);
    }

    public LocalDateTime getLastPublished() {
        return this.lastPublished;
    }

    public String getSlug() {
        return this.slug;
    }

    public Identifiable getTarget() {
        return this.target;
    }

    @Deprecated(forRemoval=true)
    public IdentifiableObjectType getTargetIdentifiableObjectType() {
        if (this.target != null) {
            return this.target.getIdentifiableObjectType();
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public IdentifiableType getTargetIdentifiableType() {
        if (this.target != null) {
            return this.target.getType();
        }
        return null;
    }

    public Locale getTargetLanguage() {
        return this.targetLanguage;
    }

    @Deprecated(forRemoval=true)
    public UUID getTargetUuid() {
        if (this.target != null) {
            return this.target.getUuid();
        }
        return null;
    }

    public Website getWebsite() {
        return this.website;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.created, this.lastModified, this.lastPublished, this.primary, this.slug, this.targetLanguage, this.target != null ? this.target.getUuid() : null, this.uuid, this.website);
    }

    @Override
    protected void init() {
        super.init();
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setLastPublished(LocalDateTime lastPublished) {
        this.lastPublished = TimestampHelper.truncatedToMicros(lastPublished);
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setTarget(Identifiable target) {
        this.target = target;
    }

    public void setTargetLanguage(Locale targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public void setWebsite(Website website) {
        this.website = website;
    }

    public String toString() {
        return "UrlAlias{created=" + this.created + ", lastModified=" + this.lastModified + ", lastPublished=" + this.lastPublished + ", primary=" + this.primary + ", slug='" + this.slug + "', target=" + (Serializable)(this.target != null ? (this.target.getUuid() != null ? this.target.getUuid() : "????") : null) + ", targetLanguage=" + this.targetLanguage + ", uuid=" + this.uuid + ", website=" + this.website + "}";
    }

    protected UrlAlias(UrlAliasBuilder<?, ?> b) {
        super(b);
        this.lastPublished = b.lastPublished;
        this.primary = b.primary;
        this.slug = b.slug;
        this.target = b.target;
        this.targetLanguage = b.targetLanguage;
        this.website = b.website;
    }

    public static UrlAliasBuilder<?, ?> builder() {
        return new UrlAliasBuilderImpl();
    }

    public static abstract class UrlAliasBuilder<C extends UrlAlias, B extends UrlAliasBuilder<C, B>>
    extends UniqueObject.UniqueObjectBuilder<C, B> {
        private LocalDateTime lastPublished;
        private boolean primary;
        private String slug;
        private Identifiable target;
        private Locale targetLanguage;
        private Website website;

        @Override
        public C build() {
            UniqueObject c = this.prebuild();
            ((UrlAlias)c).init();
            return (C)c;
        }

        public B isPrimary() {
            this.primary = true;
            return (B)this.self();
        }

        public B lastPublished(String lastPublished) {
            this.lastPublished = LocalDateTime.parse(lastPublished);
            return (B)this.self();
        }

        public B slug(String slug) {
            this.slug = slug;
            return (B)this.self();
        }

        public B targetLanguage(Locale targetLanguage) {
            this.targetLanguage = targetLanguage;
            return (B)this.self();
        }

        public B targetLanguage(String targetLanguage) {
            this.targetLanguage = Locale.forLanguageTag(targetLanguage);
            return (B)this.self();
        }

        public B target(Identifiable identifiable) {
            this.target = identifiable;
            return (B)this.self();
        }

        public B website(Website website) {
            this.website = website;
            return (B)this.self();
        }

        public B primary(boolean primary) {
            this.primary = primary;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "UrlAlias.UrlAliasBuilder(super=" + super.toString() + ", lastPublished=" + this.lastPublished + ", primary=" + this.primary + ", slug=" + this.slug + ", target=" + this.target + ", targetLanguage=" + this.targetLanguage + ", website=" + this.website + ")";
        }
    }

    private static final class UrlAliasBuilderImpl
    extends UrlAliasBuilder<UrlAlias, UrlAliasBuilderImpl> {
        private UrlAliasBuilderImpl() {
        }

        @Override
        protected UrlAliasBuilderImpl self() {
            return this;
        }

        @Override
        public UrlAlias prebuild() {
            return new UrlAlias(this);
        }
    }
}

