/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable;

import de.digitalcollections.model.UniqueObject;
import java.util.Objects;

public class Identifier
extends UniqueObject {
    private static final long serialVersionUID = 1L;
    private String id;
    private String namespace;

    public Identifier() {
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Identifier) {
            Identifier other = (Identifier)obj;
            return Objects.equals(this.id, other.getId()) && Objects.equals(this.namespace, other.getNamespace());
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.namespace);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String toString() {
        return this.namespace + ":" + this.id;
    }

    protected Identifier(IdentifierBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.namespace = b.namespace;
    }

    public static IdentifierBuilder<?, ?> builder() {
        return new IdentifierBuilderImpl();
    }

    public static abstract class IdentifierBuilder<C extends Identifier, B extends IdentifierBuilder<C, B>>
    extends UniqueObject.UniqueObjectBuilder<C, B> {
        private String id;
        private String namespace;

        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "Identifier.IdentifierBuilder(super=" + super.toString() + ", id=" + this.id + ", namespace=" + this.namespace + ")";
        }
    }

    private static final class IdentifierBuilderImpl
    extends IdentifierBuilder<Identifier, IdentifierBuilderImpl> {
        private IdentifierBuilderImpl() {
        }

        @Override
        protected IdentifierBuilderImpl self() {
            return this;
        }

        @Override
        public Identifier prebuild() {
            return new Identifier(this);
        }
    }
}

