/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model;

import de.digitalcollections.model.UniqueObject;
import java.util.Objects;

public class RelationSpecification<U extends UniqueObject> {
    private String title;
    private String sortKey;
    private U subject;

    public RelationSpecification() {
        this.title = null;
        this.sortKey = null;
        this.subject = null;
    }

    public RelationSpecification(String title, String sortKey, U subject) {
        this.title = title;
        this.sortKey = sortKey;
        this.subject = subject;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public U getSubject() {
        return this.subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public void setSubject(U subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationSpecification)) {
            return false;
        }
        RelationSpecification that = (RelationSpecification)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.sortKey, that.sortKey) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.sortKey, this.subject);
    }

    public String toString() {
        return "RelationSpecification{title='" + this.title + "', sortKey='" + this.sortKey + "', subject=" + this.subject + "}";
    }

    public static <U extends UniqueObject> RelationSpecificationBuilder<U> builder() {
        return new RelationSpecificationBuilder();
    }

    public static class RelationSpecificationBuilder<U extends UniqueObject> {
        private String title;
        private String sortKey;
        private U subject;

        RelationSpecificationBuilder() {
        }

        public RelationSpecificationBuilder<U> title(String title) {
            this.title = title;
            return this;
        }

        public RelationSpecificationBuilder<U> sortKey(String sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        public RelationSpecificationBuilder<U> subject(U subject) {
            this.subject = subject;
            return this;
        }

        public RelationSpecification<U> build() {
            return new RelationSpecification<U>(this.title, this.sortKey, this.subject);
        }

        public String toString() {
            return "RelationSpecification.RelationSpecificationBuilder(title=" + this.title + ", sortKey=" + this.sortKey + ", subject=" + this.subject + ")";
        }
    }
}

