/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.view;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Locale;
import java.util.UUID;

public class RenderingTemplate
extends UniqueObject {
    private LocalizedText description;
    private LocalizedText label;
    private String name;

    public static Builder builder() {
        return new Builder();
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public LocalizedText getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(LocalizedText description) {
        this.description = description;
    }

    public void setLabel(LocalizedText label) {
        this.label = label;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class Builder {
        private RenderingTemplate renderingTemplate = new RenderingTemplate();

        public RenderingTemplate build() {
            return this.renderingTemplate;
        }

        public Builder description(Locale locale, String text) {
            LocalizedText description = this.renderingTemplate.getDescription();
            if (description == null) {
                description = new LocalizedText();
            }
            description.setText(locale, text);
            this.renderingTemplate.setDescription(description);
            return this;
        }

        public Builder label(Locale locale, String localizedLabel) {
            LocalizedText label = this.renderingTemplate.getLabel();
            if (label == null) {
                label = new LocalizedText();
            }
            label.setText(locale, localizedLabel);
            this.renderingTemplate.setLabel(label);
            return this;
        }

        public Builder name(String name) {
            this.renderingTemplate.setName(name);
            return this;
        }

        public Builder uuid(String uuid) {
            this.renderingTemplate.setUuid(UUID.fromString(uuid));
            return this;
        }
    }
}

