/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.text.contentblock;

import de.digitalcollections.model.text.contentblock.ContentBlock;
import de.digitalcollections.model.text.contentblock.Mark;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Text
extends ContentBlock {
    private List<Mark> marks;
    private String text;

    public Text() {
    }

    public Text(String text) {
        this.text = text;
    }

    public Text(String text, String ... marks) {
        this(text);
        if (marks != null) {
            for (String markStr : marks) {
                Mark mark = new Mark(markStr);
                this.addMark(mark);
            }
        }
    }

    public void addMark(Mark mark) {
        if (this.marks == null) {
            this.marks = new ArrayList<Mark>(0);
        }
        this.marks.add(mark);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text text1 = (Text)o;
        return Objects.equals(this.text, text1.text) && Objects.equals(this.marks, text1.marks);
    }

    public List<Mark> getMarks() {
        return this.marks;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hash(this.text, this.marks);
    }

    public void setMarks(List<Mark> marks) {
        this.marks = marks;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{text='" + this.text + "', marks=" + this.marks + ", hashCode=" + this.hashCode() + "}";
    }
}

