/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.production;

import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import java.time.LocalDate;

public class CreationInfo {
    private Agent creator;
    private LocalDate date;
    private GeoLocation geoLocation;

    public static Builder builder() {
        return new Builder();
    }

    public Agent getCreator() {
        return this.creator;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    public void setCreator(Agent creator) {
        this.creator = creator;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void setGeoLocation(GeoLocation geoLocation) {
        this.geoLocation = geoLocation;
    }

    public String toString() {
        return "CreationInfo{geoLocation=" + this.geoLocation + ", date=" + this.date + ", creator=" + this.creator + "}";
    }

    public static class Builder {
        CreationInfo creationInfo = new CreationInfo();

        public CreationInfo build() {
            return this.creationInfo;
        }

        public Builder creator(Agent creator) {
            this.creationInfo.setCreator(creator);
            return this;
        }

        public Builder date(String date) {
            this.creationInfo.setDate(LocalDate.parse(date));
            return this;
        }

        public Builder geoLocation(GeoLocation geoLocation) {
            this.creationInfo.setGeoLocation(geoLocation);
            return this;
        }
    }
}

