/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.paging;

import de.digitalcollections.model.list.ListResponse;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class PageResponse<T>
extends ListResponse<T, PageRequest> {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Class c) {
        return new Builder(c);
    }

    public PageResponse() {
        this.init();
    }

    public PageResponse(List<T> content) {
        this(content, null, null == content ? 0L : (long)content.size());
    }

    public PageResponse(List<T> content, PageRequest request, long total) {
        this(content, request, total, null);
    }

    public PageResponse(List<T> content, PageRequest request, long total, String executedSearchTerm) {
        super(content, request, executedSearchTerm);
        this.total = !content.isEmpty() && request != null && (long)(request.getOffset() + request.getPageSize()) > total ? (long)(request.getOffset() + content.size()) : total;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageResponse)) {
            return false;
        }
        return super.equals(obj);
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    public int getPageNumber() {
        return this.request == null ? 0 : ((PageRequest)this.request).getPageNumber();
    }

    public int getSize() {
        return this.request == null ? 0 : ((PageRequest)this.request).getPageSize();
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public boolean hasNext() {
        return this.getPageNumber() + 1 < this.getTotalPages();
    }

    public boolean hasPrevious() {
        return this.getPageNumber() > 0;
    }

    @Override
    protected void init() {
        super.init();
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public PageRequest nextPageRequest() {
        return this.hasNext() ? ((PageRequest)this.request).next() : null;
    }

    public PageRequest previousPageRequest() {
        if (this.hasPrevious()) {
            return ((PageRequest)this.request).previousOrFirst();
        }
        return null;
    }

    @Override
    public String toString() {
        String contentType = "UNKNOWN";
        List unmodifiableContent = this.getContent();
        if (!unmodifiableContent.isEmpty()) {
            contentType = unmodifiableContent.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getPageNumber() + 1, this.getTotalPages(), contentType);
    }

    public static class Builder<T, B extends PageResponse<T>, C extends Builder> {
        List<FilterCriterion> filterCriteria;
        List<Order> orders;
        PageRequest request = new PageRequest();
        B pageResponse = new PageResponse();

        public Builder() {
        }

        public Builder(Class<T> clazz) {
        }

        public B build() {
            if (this.filterCriteria != null && !this.filterCriteria.isEmpty()) {
                this.request.setFiltering(new Filtering(this.filterCriteria));
            }
            if (this.orders != null && !this.orders.isEmpty()) {
                Sorting sorting = new Sorting();
                sorting.setOrders(this.orders);
                this.request.setSorting(sorting);
            }
            if (((ListResponse)this.pageResponse).getTotalElements() == 0L && ((ListResponse)this.pageResponse).getContent() != null && !((ListResponse)this.pageResponse).getContent().isEmpty()) {
                ((ListResponse)this.pageResponse).setTotalElements(((ListResponse)this.pageResponse).getContent().size());
            }
            ((ListResponse)this.pageResponse).setRequest((PageRequest)this.request);
            return this.pageResponse;
        }

        public C forAscendingOrderedField(String expression, String subfield) {
            Object order = ((Order.OrderBuilder)((Order.OrderBuilder)((Order.OrderBuilder)Order.builder().direction(Direction.ASC)).property(expression)).subProperty(subfield)).build();
            if (this.orders == null) {
                this.orders = new ArrayList<Order>(0);
            }
            this.orders.add((Order)order);
            return (C)this;
        }

        public C forAscendingOrderedField(String expression) {
            return this.forAscendingOrderedField(expression, "");
        }

        public C forDescendingOrderedField(String expression, String subfield) {
            Object order = ((Order.OrderBuilder)((Order.OrderBuilder)((Order.OrderBuilder)Order.builder().direction(Direction.DESC)).property(expression)).subProperty(subfield)).build();
            if (this.orders == null) {
                this.orders = new ArrayList<Order>(0);
            }
            this.orders.add((Order)order);
            return (C)this;
        }

        public C forDescendingOrderedField(String expression) {
            return this.forDescendingOrderedField(expression, "");
        }

        public C forEndDate(String expression, String endDate) {
            FilterCriterion filterCriterionEnd = new FilterCriterion(expression, FilterOperation.GREATER_THAN_OR_NOT_SET, LocalDate.parse(endDate));
            if (this.filterCriteria == null) {
                this.filterCriteria = new ArrayList<FilterCriterion>(0);
            }
            this.filterCriteria.add(filterCriterionEnd);
            return (C)this;
        }

        public C forEqualPredicate(String expression, String predicate) {
            if (this.filterCriteria == null) {
                this.filterCriteria = new ArrayList<FilterCriterion>(0);
            }
            this.filterCriteria.add(new FilterCriterion(expression, FilterOperation.EQUALS, predicate));
            return (C)this;
        }

        public C forPageSize(int pageSize) {
            this.request.setPageSize(pageSize);
            return (C)this;
        }

        public C forRequestPage(int requestPage) {
            this.request.setPageNumber(requestPage);
            return (C)this;
        }

        public C forStartDate(String expression, String startDate) {
            FilterCriterion filterCriterionStart = new FilterCriterion(expression, FilterOperation.LESS_THAN_OR_EQUAL_TO_AND_SET, LocalDate.parse(startDate));
            if (this.filterCriteria == null) {
                this.filterCriteria = new ArrayList<FilterCriterion>(0);
            }
            this.filterCriteria.add(filterCriterionStart);
            return (C)this;
        }

        public C withContent(List<T> content) {
            ((ListResponse)this.pageResponse).setContent(content);
            return (C)this;
        }

        public C withContent(T content) {
            ((ListResponse)this.pageResponse).setContent(List.of(content));
            return (C)this;
        }

        public C withExecutedSearchTerm(String executedSearchTerm) {
            ((ListResponse)this.pageResponse).setExecutedSearchTerm(executedSearchTerm);
            return (C)this;
        }

        public C withTotalElements(long totalElements) {
            ((ListResponse)this.pageResponse).setTotalElements(totalElements);
            return (C)this;
        }

        public C withoutContent() {
            ((ListResponse)this.pageResponse).setTotalElements(0L);
            ((ListResponse)this.pageResponse).setContent(List.of());
            return (C)this;
        }
    }
}

