/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.filtering;

import de.digitalcollections.model.list.filtering.FilterCriterion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Filtering {
    private List<FilterCriterion> filterCriteria;

    public static Builder builder() {
        return new Builder();
    }

    public Filtering() {
        this.init();
    }

    public Filtering(List<FilterCriterion> filterCriteria) {
        this();
        this.filterCriteria = filterCriteria;
    }

    public List<FilterCriterion> add(Filtering filtering) {
        if (filtering == null || filtering.getFilterCriteria() == null) {
            return this.getFilterCriteria();
        }
        if (this.getFilterCriteria() == null) {
            this.setFilterCriteria(filtering.getFilterCriteria());
            return this.getFilterCriteria();
        }
        ArrayList<FilterCriterion> mergedList = new ArrayList<FilterCriterion>(this.getFilterCriteria());
        mergedList.addAll(filtering.getFilterCriteria());
        this.setFilterCriteria(mergedList);
        return this.getFilterCriteria();
    }

    public void add(FilterCriterion filterCriterion) {
        if (this.filterCriteria == null) {
            this.filterCriteria = new ArrayList<FilterCriterion>();
        }
        this.filterCriteria.add(filterCriterion);
    }

    public void add(String expression, FilterCriterion filterCriterion) {
        if (filterCriterion == null || expression == null) {
            return;
        }
        FilterCriterion filterCriterionWithExpression = new FilterCriterion(filterCriterion);
        filterCriterionWithExpression.setExpression(expression);
        this.filterCriteria.add(filterCriterionWithExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Filtering)) {
            return false;
        }
        Filtering filtering = (Filtering)o;
        return Objects.equals(this.filterCriteria, filtering.filterCriteria);
    }

    public List<FilterCriterion> getFilterCriteria() {
        return this.filterCriteria;
    }

    public FilterCriterion getFilterCriterionFor(String property) {
        return this.filterCriteria.stream().filter(f -> f.getExpression().equals(property)).findFirst().orElse(null);
    }

    public int hashCode() {
        return Objects.hash(this.filterCriteria) + Objects.hash("Filtering");
    }

    protected void init() {
        if (this.filterCriteria == null) {
            this.filterCriteria = new ArrayList<FilterCriterion>(0);
        }
    }

    public Iterator<FilterCriterion> iterator() {
        return this.filterCriteria.iterator();
    }

    public void setFilterCriteria(List<FilterCriterion> filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public String toString() {
        return "Filtering{filterCriteria=" + this.filterCriteria + "}";
    }

    public static class Builder {
        private final List<FilterCriterion> filterCriterias = new ArrayList<FilterCriterion>(0);

        public Builder add(String expression, FilterCriterion filterCriterion) {
            if (filterCriterion != null) {
                filterCriterion.setExpression(expression);
            }
            return this.add(filterCriterion);
        }

        public Builder add(FilterCriterion filterCriterion) {
            if (filterCriterion != null) {
                if (filterCriterion.getExpression() == null) {
                    throw new IllegalArgumentException("expression of a filter criterion must not be null!");
                }
                this.filterCriterias.add(filterCriterion);
            }
            return this;
        }

        public Filtering build() {
            return new Filtering(this.filterCriterias);
        }
    }
}

