/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list.filtering;

import de.digitalcollections.model.list.filtering.FilterOperation;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class FilterCriterion<T> {
    private String expression;
    private Comparable<?> maxValue;
    private Comparable<?> minValue;
    private boolean nativeExpression;
    private FilterOperation operation;
    private Object value;
    private Collection<?> values;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder nativeBuilder() {
        return new Builder().withNativeExpression(true);
    }

    public FilterCriterion() {
        this.init();
    }

    public FilterCriterion(String expression, boolean nativeExpression, FilterOperation operation, Object value, Comparable<?> minValue, Comparable<?> maxValue, Collection<?> values) {
        this.expression = expression;
        this.nativeExpression = nativeExpression;
        this.operation = operation;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.values = values;
        this.validate();
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            this.minValue = maxValue;
            this.maxValue = minValue;
        }
    }

    public FilterCriterion(String expression, FilterOperation operation, Object value, Comparable<?> minValue, Comparable<?> maxValue, Collection<?> values) {
        this(expression, false, operation, value, minValue, maxValue, values);
    }

    public FilterCriterion(String expression, FilterOperation operation, Object value) {
        this(expression, false, operation, value);
    }

    public FilterCriterion(String expression, boolean nativeExpression, FilterOperation operation, Object value) {
        this(expression, nativeExpression, operation, value, null, null, null);
        if (operation == FilterOperation.BETWEEN || operation == FilterOperation.IN || operation == FilterOperation.NOT_IN) {
            throw new IllegalArgumentException("this constructor only supports single value operations");
        }
    }

    public FilterCriterion(String expression, FilterOperation operation) {
        this(expression, false, operation);
    }

    public FilterCriterion(String expression, boolean nativeExpression, FilterOperation operation) {
        this(expression, nativeExpression, operation, null, null, null, null);
    }

    public FilterCriterion(FilterCriterion other) {
        this.expression = other.expression;
        this.maxValue = other.maxValue;
        this.minValue = other.minValue;
        this.nativeExpression = other.nativeExpression;
        this.operation = other.operation;
        this.value = other.value;
        this.values = other.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterCriterion)) {
            return false;
        }
        FilterCriterion that = (FilterCriterion)o;
        return this.nativeExpression == that.nativeExpression && Objects.equals(this.expression, that.expression) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.minValue, that.minValue) && this.operation == that.operation && Objects.equals(this.value, that.value) && Objects.equals(this.values, that.values);
    }

    public String getExpression() {
        return this.expression;
    }

    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    public FilterOperation getOperation() {
        return this.operation;
    }

    public Object getValue() {
        return this.value;
    }

    public Collection<?> getValues() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.maxValue, this.minValue, this.nativeExpression, this.operation, this.value, this.values});
    }

    protected void init() {
    }

    public boolean isNativeExpression() {
        return this.nativeExpression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Deprecated
    public void setFieldName(String expression) {
        this.setExpression(expression);
    }

    public void setNativeExpression(boolean nativeExpression) {
        this.nativeExpression = nativeExpression;
    }

    public String toString() {
        if (this.operation == null) {
            return "";
        }
        String criterion = this.expression + "=" + this.operation + ":";
        switch (this.operation.getOperandCount()) {
            case SINGLEVALUE: {
                criterion = criterion + this.value;
                break;
            }
            case MIN_MAX_VALUES: {
                criterion = criterion + this.minValue + "," + this.maxValue;
                break;
            }
            case MULTIVALUE: {
                criterion = criterion + this.values.stream().map(Object::toString).collect(Collectors.joining(","));
            }
        }
        if (this.nativeExpression) {
            return "native expression / " + criterion;
        }
        return criterion;
    }

    private void validate() {
        if (this.operation == null) {
            throw new IllegalArgumentException("a filter criterion needs an operation");
        }
        FilterOperation.OperandCount operandCount = this.operation.getOperandCount();
        switch (operandCount) {
            case NO_VALUE: {
                if (this.value == null && this.minValue == null && this.maxValue == null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation does not support operand values!");
            }
            case SINGLEVALUE: {
                if (this.value != null && this.minValue == null && this.maxValue == null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation requires exactly one operand value!");
            }
            case MIN_MAX_VALUES: {
                if (this.value == null && this.minValue != null && this.maxValue != null && (this.values == null || this.values.isEmpty())) break;
                throw new IllegalArgumentException("operation requires exactly one min and one max value!");
            }
            case MULTIVALUE: {
                if (this.value == null && this.minValue == null && this.maxValue == null && this.values != null && !this.values.isEmpty()) break;
                throw new IllegalArgumentException("operation requires a list of values!");
            }
        }
    }

    public static class Builder {
        private String expression;
        private FilterCriterion filterCriterion;
        private boolean nativeExpression;

        Builder() {
        }

        public Builder between(Comparable<?> minValue, Comparable<?> maxValue) {
            this.filterCriterion = new FilterCriterion(this.expression, false, FilterOperation.BETWEEN, null, minValue, maxValue, null);
            return this;
        }

        public FilterCriterion build() {
            return this.filterCriterion;
        }

        @Deprecated
        public Builder contains(String expression, Object value) {
            this.filterCriterion = new FilterCriterion(expression, false, FilterOperation.CONTAINS, value);
            return this;
        }

        public Builder contains(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, false, FilterOperation.CONTAINS, value);
            return this;
        }

        public Builder greater(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.GREATER_THAN, value);
            return this;
        }

        public Builder greaterOrEqual(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.GREATER_THAN_OR_EQUAL_TO, value);
            return this;
        }

        public Builder greaterOrEqualOrNotSet(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.GREATER_THAN_OR_EQUAL_TO_OR_NOT_SET, value);
            return this;
        }

        public Builder greaterOrNotSet(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.GREATER_THAN_OR_NOT_SET, value);
            return this;
        }

        public Builder in(Collection<?> values) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.IN, null, null, null, values);
            return this;
        }

        public Builder isEquals(Object value) {
            this.filterCriterion = value != null ? new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.EQUALS, value) : new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.NOT_SET);
            return this;
        }

        public Builder isEqualsOrNotSet(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.EQUALS_OR_NOT_SET, value);
            return this;
        }

        public Builder less(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.LESS_THAN, value);
            return this;
        }

        public Builder lessAndSet(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.LESS_THAN_AND_SET, value);
            return this;
        }

        public Builder lessOrEqual(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.LESS_THAN_OR_EQUAL_TO, value);
            return this;
        }

        public Builder lessOrEqualAndSet(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.LESS_THAN_OR_EQUAL_TO_AND_SET, value);
            return this;
        }

        public Builder lessOrEqualOrNotSet(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.LESS_THAN_OR_EQUAL_TO_OR_NOT_SET, value);
            return this;
        }

        public Builder lessOrNotSet(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.LESS_THAN_OR_NOT_SET, value);
            return this;
        }

        public Builder notEquals(Object value) {
            this.filterCriterion = value != null ? new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.NOT_EQUALS, value) : new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.SET);
            return this;
        }

        public Builder notIn(Collection<?> values) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.NOT_IN, null, null, null, values);
            return this;
        }

        public Builder notSet() {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.NOT_SET, null);
            return this;
        }

        public Builder set() {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.SET, null);
            return this;
        }

        public Builder startsWith(Object value) {
            this.filterCriterion = new FilterCriterion(this.expression, this.nativeExpression, FilterOperation.STARTS_WITH, value);
            return this;
        }

        public Builder withExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder withNativeExpression(boolean nativeExpression) {
            this.nativeExpression = nativeExpression;
            return this;
        }
    }
}

