/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.list;

import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ListResponse<T, R extends ListRequest>
implements Iterable<T> {
    protected List<T> content;
    protected String executedSearchTerm;
    protected R request;
    protected long total;

    public ListResponse() {
        this.init();
    }

    public ListResponse(List<T> content, R request) {
        this();
        assert (content != null) : "content must not be null!";
        this.content.addAll(content);
        this.request = request;
        this.total = content.size();
    }

    public ListResponse(List<T> content, R request, String executedSearchTerm) {
        this(content, request);
        this.executedSearchTerm = executedSearchTerm;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ListResponse)) {
            return false;
        }
        ListResponse that = (ListResponse)obj;
        return this.total == that.total && Objects.equals(this.content, that.content) && Objects.equals(this.executedSearchTerm, that.executedSearchTerm) && Objects.equals(this.request, that.request);
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public String getExecutedSearchTerm() {
        if (this.executedSearchTerm == null) {
            return this.request != null ? ((ListRequest)this.request).getSearchTerm() : null;
        }
        return this.executedSearchTerm;
    }

    public R getRequest() {
        return this.request;
    }

    public Sorting getSorting() {
        return this.request == null ? null : ((ListRequest)this.request).getSorting();
    }

    public long getTotalElements() {
        return this.total;
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public int hashCode() {
        int result = 17;
        result += 31 * (int)(this.total ^ this.total >>> 32);
        result += 31 * (this.request == null ? 0 : ((ListRequest)this.request).hashCode());
        result += 31 * this.content.hashCode();
        return result += 31 * (this.executedSearchTerm == null ? 0 : this.executedSearchTerm.hashCode());
    }

    protected void init() {
        if (this.content == null) {
            this.content = new ArrayList<T>(0);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setExecutedSearchTerm(String executedSearchTerm) {
        this.executedSearchTerm = executedSearchTerm;
    }

    public void setRequest(R request) {
        this.request = request;
    }

    public void setTotalElements(long totalElements) {
        this.total = totalElements;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List<T> unmodifiableContent = this.getContent();
        if (!unmodifiableContent.isEmpty()) {
            contentType = unmodifiableContent.get(0).getClass().getName();
        }
        return String.format("List of %s containing %d instances", contentType, unmodifiableContent.size());
    }
}

