/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.legal;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.text.LocalizedText;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;

public class License
extends UniqueObject {
    private String acronym;
    private LocalizedText label;
    private URL url;

    public License() {
        this.init();
    }

    public License(String acronym, LocalizedText label, URL url) {
        this();
        this.acronym = acronym;
        this.label = label;
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License license = (License)o;
        return Objects.equals(this.acronym, license.acronym) && Objects.equals(this.label, license.label) && Objects.equals(this.url, license.url) && Objects.equals(this.uuid, license.uuid);
    }

    public String getAcronym() {
        return this.acronym;
    }

    public LocalizedText getLabel() {
        return this.label;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.acronym, this.label, this.url, this.uuid);
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public void setLabel(LocalizedText label) {
        this.label = label;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String toString() {
        return "License{created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + ", acronym='" + this.acronym + "', label=" + this.label + ", url=" + this.url + "}";
    }

    protected License(LicenseBuilder<?, ?> b) {
        super(b);
        this.acronym = b.acronym;
        this.label = b.label;
        this.url = b.url;
    }

    public static LicenseBuilder<?, ?> builder() {
        return new LicenseBuilderImpl();
    }

    private static final class LicenseBuilderImpl
    extends LicenseBuilder<License, LicenseBuilderImpl> {
        private LicenseBuilderImpl() {
        }

        @Override
        protected LicenseBuilderImpl self() {
            return this;
        }

        @Override
        public License prebuild() {
            return new License(this);
        }
    }

    public static abstract class LicenseBuilder<C extends License, B extends LicenseBuilder<C, B>>
    extends UniqueObject.UniqueObjectBuilder<C, B> {
        private String acronym;
        private LocalizedText label;
        private URL url;

        @Override
        public C build() {
            UniqueObject c = this.prebuild();
            ((License)c).init();
            return (C)c;
        }

        public B label(Locale locale, String localizedLabel) {
            if (this.label == null) {
                this.label = new LocalizedText();
            }
            this.label.setText(locale, localizedLabel);
            return (B)this.self();
        }

        public B url(String url) {
            if (url == null) {
                return (B)this.self();
            }
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Cannot set url=" + url + ": " + e, e);
            }
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B acronym(String acronym) {
            this.acronym = acronym;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "License.LicenseBuilder(super=" + super.toString() + ", acronym=" + this.acronym + ", label=" + this.label + ", url=" + this.url + ")";
        }
    }
}

