/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.web;

import de.digitalcollections.model.identifiable.INode;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.Node;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.view.RenderingHints;
import java.time.LocalDate;
import java.util.List;

public class Webpage
extends Identifiable
implements INode<Webpage> {
    private Node<Webpage> node;
    private LocalDate publicationEnd;
    private LocalDate publicationStart;
    private RenderingHints renderingHints;
    private LocalizedStructuredContent text;

    public Webpage() {
        this.init();
    }

    public Webpage(List<Webpage> children) {
        this();
        this.node.setChildren(children);
    }

    @Override
    public List<Webpage> getChildren() {
        return this.node.getChildren();
    }

    @Override
    public LocalizedText getLabel() {
        return this.label;
    }

    @Override
    public Webpage getParent() {
        return this.node.getParent();
    }

    public LocalDate getPublicationEnd() {
        return this.publicationEnd;
    }

    public LocalDate getPublicationStart() {
        return this.publicationStart;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public LocalizedStructuredContent getText() {
        return this.text;
    }

    @Override
    protected void init() {
        super.init();
        this.type = IdentifiableType.RESOURCE;
        if (this.node == null) {
            this.node = new Node();
        }
    }

    @Override
    public void setChildren(List<Webpage> children) {
        this.node.setChildren(children);
    }

    @Override
    public void setParent(Webpage parent) {
        this.node.setParent(parent);
    }

    public void setPublicationEnd(LocalDate publicationEnd) {
        this.publicationEnd = publicationEnd;
    }

    public void setPublicationStart(LocalDate publicationStart) {
        this.publicationStart = publicationStart;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }

    public void setText(LocalizedStructuredContent text) {
        this.text = text;
    }

    protected Webpage(WebpageBuilder<?, ?> b) {
        super((Identifiable.IdentifiableBuilder<?, ?>)b);
        this.node = b.node;
        this.publicationEnd = b.publicationEnd;
        this.publicationStart = b.publicationStart;
        this.renderingHints = b.renderingHints;
        this.text = b.text;
    }

    public static WebpageBuilder<?, ?> builder() {
        return new WebpageBuilderImpl();
    }

    private static final class WebpageBuilderImpl
    extends WebpageBuilder<Webpage, WebpageBuilderImpl> {
        private WebpageBuilderImpl() {
        }

        @Override
        protected WebpageBuilderImpl self() {
            return this;
        }

        @Override
        public Webpage prebuild() {
            return new Webpage(this);
        }
    }

    public static abstract class WebpageBuilder<C extends Webpage, B extends WebpageBuilder<C, B>>
    extends Identifiable.IdentifiableBuilder<C, B> {
        private Node<Webpage> node;
        private LocalDate publicationEnd;
        private LocalDate publicationStart;
        private RenderingHints renderingHints;
        private LocalizedStructuredContent text;
        private List<Webpage> children;

        @Override
        public C build() {
            Identifiable c = this.prebuild();
            ((Webpage)c).init();
            return (C)c;
        }

        public B children(List<Webpage> children) {
            if (this.node == null) {
                this.node = new Node();
            }
            this.node.setChildren(children);
            return (B)this.self();
        }

        public B notShownInNavigation() {
            if (this.renderingHints == null) {
                this.renderingHints = new RenderingHints();
            }
            this.renderingHints.setShowInPageNavigation(false);
            return (B)this.self();
        }

        public B publicationEnd(String publicationEnd) {
            this.publicationEnd = LocalDate.parse(publicationEnd);
            return (B)this.self();
        }

        public B publicationStart(String publicationStart) {
            this.publicationStart = LocalDate.parse(publicationStart);
            return (B)this.self();
        }

        public B shownInNavigation() {
            if (this.renderingHints == null) {
                this.renderingHints = new RenderingHints();
            }
            this.renderingHints.setShowInPageNavigation(true);
            return (B)this.self();
        }

        public B templateName(String templateName) {
            if (this.renderingHints == null) {
                this.renderingHints = new RenderingHints();
            }
            this.renderingHints.setTemplateName(templateName);
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B node(Node<Webpage> node) {
            this.node = node;
            return (B)this.self();
        }

        public B renderingHints(RenderingHints renderingHints) {
            this.renderingHints = renderingHints;
            return (B)this.self();
        }

        public B text(LocalizedStructuredContent text) {
            this.text = text;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Webpage.WebpageBuilder(super=" + super.toString() + ", node=" + this.node + ", publicationEnd=" + this.publicationEnd + ", publicationStart=" + this.publicationStart + ", renderingHints=" + this.renderingHints + ", text=" + this.text + ")";
        }
    }
}

