/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import java.net.URI;
import java.util.Objects;

public class LinkedDataFileResource
extends FileResource {
    private URI context;
    private String objectType;

    public LinkedDataFileResource() {
        this.init();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinkedDataFileResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinkedDataFileResource that = (LinkedDataFileResource)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.objectType, that.objectType);
    }

    public URI getContext() {
        return this.context;
    }

    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.context, this.objectType);
    }

    @Override
    protected void init() {
        super.init();
        this.fileResourceType = FileResourceType.LINKED_DATA;
    }

    public void setContext(URI context) {
        this.context = context;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    protected LinkedDataFileResource(LinkedDataFileResourceBuilder<?, ?> b) {
        super((FileResource.FileResourceBuilder<?, ?>)b);
        this.context = b.context;
        this.objectType = b.objectType;
    }

    public static LinkedDataFileResourceBuilder<?, ?> builder() {
        return new LinkedDataFileResourceBuilderImpl();
    }

    private static final class LinkedDataFileResourceBuilderImpl
    extends LinkedDataFileResourceBuilder<LinkedDataFileResource, LinkedDataFileResourceBuilderImpl> {
        private LinkedDataFileResourceBuilderImpl() {
        }

        @Override
        protected LinkedDataFileResourceBuilderImpl self() {
            return this;
        }

        @Override
        public LinkedDataFileResource prebuild() {
            return new LinkedDataFileResource(this);
        }
    }

    public static abstract class LinkedDataFileResourceBuilder<C extends LinkedDataFileResource, B extends LinkedDataFileResourceBuilder<C, B>>
    extends FileResource.FileResourceBuilder<C, B> {
        private URI context;
        private String objectType;

        @Override
        public C build() {
            FileResource c = this.prebuild();
            ((LinkedDataFileResource)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B context(String context) {
            this.context = URI.create(context);
            return (B)this.self();
        }

        @Override
        public B uri(String uri) {
            return (B)((LinkedDataFileResourceBuilder)this.uri(URI.create(uri)));
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B objectType(String objectType) {
            this.objectType = objectType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "LinkedDataFileResource.LinkedDataFileResourceBuilder(super=" + super.toString() + ", context=" + this.context + ", objectType=" + this.objectType + ")";
        }
    }
}

