/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.resource;

import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;

public class ImageFileResource
extends FileResource {
    private int height;
    private int width;

    public static PreviewImageBuilder previewImageBuilder() {
        return new PreviewImageBuilder();
    }

    public ImageFileResource() {
        this.init();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageFileResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageFileResource that = (ImageFileResource)o;
        return this.height == that.height && this.width == that.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.height, this.width);
    }

    @Override
    protected void init() {
        super.init();
        this.fileResourceType = FileResourceType.IMAGE;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    protected ImageFileResource(ImageFileResourceBuilder<?, ?> b) {
        super((FileResource.FileResourceBuilder<?, ?>)b);
        this.height = b.height;
        this.width = b.width;
    }

    public static ImageFileResourceBuilder<?, ?> builder() {
        return new ImageFileResourceBuilderImpl();
    }

    private static final class ImageFileResourceBuilderImpl
    extends ImageFileResourceBuilder<ImageFileResource, ImageFileResourceBuilderImpl> {
        private ImageFileResourceBuilderImpl() {
        }

        @Override
        protected ImageFileResourceBuilderImpl self() {
            return this;
        }

        @Override
        public ImageFileResource prebuild() {
            return new ImageFileResource(this);
        }
    }

    public static class PreviewImageBuilder {
        ImageFileResource previewImage = new ImageFileResource();

        public PreviewImageBuilder() {
            this.previewImage.setFileResourceType(FileResourceType.IMAGE);
            this.previewImage.setMimeType(MimeType.MIME_IMAGE);
        }

        public PreviewImageBuilder(String uuid) {
            this();
            this.previewImage.setUuid(UUID.fromString(uuid));
        }

        public ImageFileResource build() {
            this.previewImage.setFileResourceType(FileResourceType.IMAGE);
            if (this.previewImage.getMimeType() == null) {
                this.previewImage.setMimeType(MimeType.MIME_IMAGE);
            }
            return this.previewImage;
        }

        public PreviewImageBuilder fileName(String fileName) {
            this.previewImage.setFilename(fileName);
            return this;
        }

        public PreviewImageBuilder httpBaseUrl(String httpBaseUrl) {
            try {
                this.previewImage.setHttpBaseUrl(new URL(httpBaseUrl));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public PreviewImageBuilder mimeType(MimeType mimeType) {
            this.previewImage.setMimeType(mimeType);
            return this;
        }

        public PreviewImageBuilder size(int width, int height) {
            this.previewImage.setWidth(width);
            this.previewImage.setHeight(height);
            return this;
        }

        public PreviewImageBuilder uri(String uri) {
            this.previewImage.setUri(URI.create(uri));
            return this;
        }

        public PreviewImageBuilder uuid(UUID uuid) {
            this.previewImage.setUuid(uuid);
            return this;
        }

        public PreviewImageBuilder uuid(String uuid) {
            this.previewImage.setUuid(UUID.fromString(uuid));
            return this;
        }
    }

    public static abstract class ImageFileResourceBuilder<C extends ImageFileResource, B extends ImageFileResourceBuilder<C, B>>
    extends FileResource.FileResourceBuilder<C, B> {
        private int height;
        private int width;

        @Override
        public C build() {
            FileResource c = this.prebuild();
            ((ImageFileResource)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B height(int height) {
            this.height = height;
            return (B)this.self();
        }

        public B width(int width) {
            this.width = width;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ImageFileResource.ImageFileResourceBuilder(super=" + super.toString() + ", height=" + this.height + ", width=" + this.width + ")";
        }
    }
}

