/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.work;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Locale;

public class Item
extends Entity {
    private Locale language;
    private String publicationDate;
    private String publicationPlace;
    private String publisher;
    private String version;

    public Item() {
        this.init();
    }

    public Locale getLanguage() {
        return this.language;
    }

    public String getPublicationDate() {
        return this.publicationDate;
    }

    public String getPublicationPlace() {
        return this.publicationPlace;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public LocalizedText getTitle() {
        return this.getLabel();
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    protected void init() {
        super.init();
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public void setPublicationDate(String publicationDate) {
        this.publicationDate = publicationDate;
    }

    public void setPublicationPlace(String publicationPlace) {
        this.publicationPlace = publicationPlace;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setTitle(LocalizedText title) {
        this.setLabel(title);
    }

    public void setTitle(String title) {
        this.setLabel(title);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{language=" + this.language + ", publicationDate='" + this.publicationDate + "', publicationPlace='" + this.publicationPlace + "', publisher='" + this.publisher + "', version='" + this.version + ", refId=" + this.refId + ", created=" + this.created + ", description=" + this.description + ", label=" + this.label + ", lastModified=" + this.lastModified + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", type=" + this.type + "}";
    }

    protected Item(ItemBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.language = b.language;
        this.publicationDate = b.publicationDate;
        this.publicationPlace = b.publicationPlace;
        this.publisher = b.publisher;
        this.version = b.version;
    }

    public static ItemBuilder<?, ?> builder() {
        return new ItemBuilderImpl();
    }

    private static final class ItemBuilderImpl
    extends ItemBuilder<Item, ItemBuilderImpl> {
        private ItemBuilderImpl() {
        }

        @Override
        protected ItemBuilderImpl self() {
            return this;
        }

        @Override
        public Item prebuild() {
            return new Item(this);
        }
    }

    public static abstract class ItemBuilder<C extends Item, B extends ItemBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private Locale language;
        private String publicationDate;
        private String publicationPlace;
        private String publisher;
        private String version;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Item)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B language(Locale language) {
            this.language = language;
            return (B)this.self();
        }

        public B publicationDate(String publicationDate) {
            this.publicationDate = publicationDate;
            return (B)this.self();
        }

        public B publicationPlace(String publicationPlace) {
            this.publicationPlace = publicationPlace;
            return (B)this.self();
        }

        public B publisher(String publisher) {
            this.publisher = publisher;
            return (B)this.self();
        }

        public B version(String version) {
            this.version = version;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Item.ItemBuilder(super=" + super.toString() + ", language=" + this.language + ", publicationDate=" + this.publicationDate + ", publicationPlace=" + this.publicationPlace + ", publisher=" + this.publisher + ", version=" + this.version + ")";
        }
    }
}

