/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.agent;

import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.agent.FamilyName;
import de.digitalcollections.model.identifiable.agent.GivenName;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.Gender;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import de.digitalcollections.model.text.LocalizedText;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;

public class Person
extends Agent {
    private LocalDate dateOfBirth;
    private LocalDate dateOfDeath;
    private List<FamilyName> familyNames;
    private Gender gender;
    private List<GivenName> givenNames;
    private GeoLocation placeOfBirth;
    private GeoLocation placeOfDeath;
    private TimeValue timeValueOfBirth;
    private TimeValue timeValueOfDeath;

    public Person() {
        this.init();
    }

    public Person(LocalizedText label, Set<Identifier> identifiers) {
        this();
        this.label = label;
        this.identifiers.addAll(identifiers);
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public LocalDate getDateOfDeath() {
        return this.dateOfDeath;
    }

    public List<FamilyName> getFamilyNames() {
        return this.familyNames;
    }

    public Gender getGender() {
        return this.gender;
    }

    public List<GivenName> getGivenNames() {
        return this.givenNames;
    }

    public GeoLocation getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public GeoLocation getPlaceOfDeath() {
        return this.placeOfDeath;
    }

    public TimeValue getTimeValueOfBirth() {
        return this.timeValueOfBirth;
    }

    public TimeValue getTimeValueOfDeath() {
        return this.timeValueOfDeath;
    }

    @Override
    protected void init() {
        super.init();
        if (this.familyNames == null) {
            this.familyNames = new ArrayList<FamilyName>(0);
        }
        if (this.givenNames == null) {
            this.givenNames = new ArrayList<GivenName>(0);
        }
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfDeath(LocalDate dateOfDeath) {
        this.dateOfDeath = dateOfDeath;
    }

    public void setFamilyNames(List<FamilyName> familyNames) {
        this.familyNames = familyNames;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public void setGivenNames(List<GivenName> givenNames) {
        this.givenNames = givenNames;
    }

    public void setPlaceOfBirth(GeoLocation placeOfBirth) {
        this.placeOfBirth = placeOfBirth;
    }

    public void setPlaceOfDeath(GeoLocation placeOfDeath) {
        this.placeOfDeath = placeOfDeath;
    }

    public void setTimeValueOfBirth(TimeValue timeValueOfBirth) {
        this.timeValueOfBirth = timeValueOfBirth;
    }

    public void setTimeValueOfDeath(TimeValue timeValueOfDeath) {
        this.timeValueOfDeath = timeValueOfDeath;
    }

    protected Person(PersonBuilder<?, ?> b) {
        super((Agent.AgentBuilder<?, ?>)b);
        this.dateOfBirth = b.dateOfBirth;
        this.dateOfDeath = b.dateOfDeath;
        this.familyNames = b.familyNames;
        this.gender = b.gender;
        this.givenNames = b.givenNames;
        this.placeOfBirth = b.placeOfBirth;
        this.placeOfDeath = b.placeOfDeath;
        this.timeValueOfBirth = b.timeValueOfBirth;
        this.timeValueOfDeath = b.timeValueOfDeath;
    }

    public static PersonBuilder<?, ?> builder() {
        return new PersonBuilderImpl();
    }

    private static final class PersonBuilderImpl
    extends PersonBuilder<Person, PersonBuilderImpl> {
        private PersonBuilderImpl() {
        }

        @Override
        protected PersonBuilderImpl self() {
            return this;
        }

        @Override
        public Person prebuild() {
            return new Person(this);
        }
    }

    public static abstract class PersonBuilder<C extends Person, B extends PersonBuilder<C, B>>
    extends Agent.AgentBuilder<C, B> {
        private LocalDate dateOfBirth;
        private LocalDate dateOfDeath;
        private List<FamilyName> familyNames;
        private Gender gender;
        private List<GivenName> givenNames;
        private GeoLocation placeOfBirth;
        private GeoLocation placeOfDeath;
        private TimeValue timeValueOfBirth;
        private TimeValue timeValueOfDeath;

        @Override
        public C build() {
            Agent c = this.prebuild();
            ((Person)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B dateOfBirth(LocalDate dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return (B)this.self();
        }

        public B dateOfDeath(LocalDate dateOfDeath) {
            this.dateOfDeath = dateOfDeath;
            return (B)this.self();
        }

        public B familyNames(List<FamilyName> familyNames) {
            this.familyNames = familyNames;
            return (B)this.self();
        }

        public B gender(Gender gender) {
            this.gender = gender;
            return (B)this.self();
        }

        public B givenNames(List<GivenName> givenNames) {
            this.givenNames = givenNames;
            return (B)this.self();
        }

        public B placeOfBirth(GeoLocation placeOfBirth) {
            this.placeOfBirth = placeOfBirth;
            return (B)this.self();
        }

        public B placeOfDeath(GeoLocation placeOfDeath) {
            this.placeOfDeath = placeOfDeath;
            return (B)this.self();
        }

        public B timeValueOfBirth(TimeValue timeValueOfBirth) {
            this.timeValueOfBirth = timeValueOfBirth;
            return (B)this.self();
        }

        public B timeValueOfDeath(TimeValue timeValueOfDeath) {
            this.timeValueOfDeath = timeValueOfDeath;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Person.PersonBuilder(super=" + super.toString() + ", dateOfBirth=" + this.dateOfBirth + ", dateOfDeath=" + this.dateOfDeath + ", familyNames=" + this.familyNames + ", gender=" + this.gender + ", givenNames=" + this.givenNames + ", placeOfBirth=" + this.placeOfBirth + ", placeOfDeath=" + this.placeOfDeath + ", timeValueOfBirth=" + this.timeValueOfBirth + ", timeValueOfDeath=" + this.timeValueOfDeath + ")";
        }
    }
}

