/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity.agent;

import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.StructuredContent;
import de.digitalcollections.model.text.contentblock.Paragraph;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;

public class CorporateBody
extends Agent {
    private URL homepageUrl;
    private LocalizedStructuredContent text;

    public CorporateBody() {
        this.init();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CorporateBody)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CorporateBody that = (CorporateBody)o;
        return Objects.equals(this.homepageUrl, that.homepageUrl) && Objects.equals(this.text, that.text);
    }

    public URL getHomepageUrl() {
        return this.homepageUrl;
    }

    public LocalizedStructuredContent getText() {
        return this.text;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.homepageUrl, this.text);
    }

    @Override
    protected void init() {
        super.init();
    }

    public void setHomepageUrl(URL homepageUrl) {
        this.homepageUrl = homepageUrl;
    }

    public void setText(LocalizedStructuredContent text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return "CorporateBody{created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + ", description=" + this.description + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", type=" + this.type + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + ", homepageUrl=" + this.homepageUrl + ", text=" + this.text + "}@" + this.hashCode();
    }

    protected CorporateBody(CorporateBodyBuilder<?, ?> b) {
        super((Agent.AgentBuilder<?, ?>)b);
        this.homepageUrl = b.homepageUrl;
        this.text = b.text;
    }

    public static CorporateBodyBuilder<?, ?> builder() {
        return new CorporateBodyBuilderImpl();
    }

    private static final class CorporateBodyBuilderImpl
    extends CorporateBodyBuilder<CorporateBody, CorporateBodyBuilderImpl> {
        private CorporateBodyBuilderImpl() {
        }

        @Override
        protected CorporateBodyBuilderImpl self() {
            return this;
        }

        @Override
        public CorporateBody prebuild() {
            return new CorporateBody(this);
        }
    }

    public static abstract class CorporateBodyBuilder<C extends CorporateBody, B extends CorporateBodyBuilder<C, B>>
    extends Agent.AgentBuilder<C, B> {
        private URL homepageUrl;
        private LocalizedStructuredContent text;

        @Override
        public C build() {
            Agent c = this.prebuild();
            ((CorporateBody)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B homepageUrl(String homepageUrl) {
            try {
                this.homepageUrl = new URL(homepageUrl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return (B)this.self();
        }

        public B homepageUrl(URL homepageUrl) {
            this.homepageUrl = homepageUrl;
            return (B)this.self();
        }

        public B text(Locale locale, String text) {
            StructuredContent localizedDescription;
            if (this.text == null) {
                this.text = new LocalizedStructuredContent();
            }
            if ((localizedDescription = (StructuredContent)this.text.get(locale)) == null) {
                localizedDescription = new StructuredContent();
            }
            Paragraph paragraph = text != null && !text.isBlank() ? new Paragraph(text) : new Paragraph();
            localizedDescription.addContentBlock(paragraph);
            this.text.put(locale, localizedDescription);
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        @Override
        public String toString() {
            return "CorporateBody.CorporateBodyBuilder(super=" + super.toString() + ", homepageUrl=" + this.homepageUrl + ", text=" + this.text + ")";
        }
    }
}

