/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.web.Webpage;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.util.List;

public class Website
extends Entity {
    private LocalDate registrationDate;
    private List<? extends Webpage> rootPages;
    private URL url;

    public Website() {
        this.init();
    }

    public Website(URL url) {
        this(null, url, null);
    }

    public Website(List<Webpage> rootPages, URL url, LocalDate registrationDate) {
        this();
        this.registrationDate = registrationDate;
        this.rootPages = rootPages;
        this.url = url;
    }

    public LocalDate getRegistrationDate() {
        return this.registrationDate;
    }

    public List<? extends Webpage> getRootPages() {
        return this.rootPages;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    protected void init() {
        super.init();
    }

    public void setRegistrationDate(LocalDate registrationDate) {
        this.registrationDate = registrationDate;
    }

    public void setRootPages(List<? extends Webpage> rootPages) {
        this.rootPages = rootPages;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    protected Website(WebsiteBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.registrationDate = b.registrationDate;
        this.rootPages = b.rootPages;
        this.url = b.url;
    }

    public static WebsiteBuilder<?, ?> builder() {
        return new WebsiteBuilderImpl();
    }

    private static final class WebsiteBuilderImpl
    extends WebsiteBuilder<Website, WebsiteBuilderImpl> {
        private WebsiteBuilderImpl() {
        }

        @Override
        protected WebsiteBuilderImpl self() {
            return this;
        }

        @Override
        public Website prebuild() {
            return new Website(this);
        }
    }

    public static abstract class WebsiteBuilder<C extends Website, B extends WebsiteBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private LocalDate registrationDate;
        private List<? extends Webpage> rootPages;
        private URL url;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Website)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B registrationDate(String registrationDate) {
            this.registrationDate = LocalDate.parse(registrationDate);
            return (B)this.self();
        }

        public B url(String url) {
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B rootPages(List<? extends Webpage> rootPages) {
            this.rootPages = rootPages;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Website.WebsiteBuilder(super=" + super.toString() + ", registrationDate=" + this.registrationDate + ", rootPages=" + this.rootPages + ", url=" + this.url + ")";
        }
    }
}

