/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.entity.CustomAttributes;
import de.digitalcollections.model.identifiable.entity.EntityType;
import java.time.LocalDate;
import java.util.Objects;

public class Entity
extends Identifiable {
    protected CustomAttributes customAttributes;
    protected LocalDate navDate;
    protected long refId;

    public Entity() {
        this.init();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.refId == entity.refId && Objects.equals(this.customAttributes, entity.customAttributes) && Objects.equals(this.navDate, entity.navDate);
    }

    public Object getCustomAttribute(String attributeName) {
        if (this.hasCustomAttribute(attributeName)) {
            return this.getCustomAttributes().get(attributeName);
        }
        return null;
    }

    public CustomAttributes getCustomAttributes() {
        return this.customAttributes;
    }

    @Deprecated(forRemoval=true, since="10.0.0")
    public EntityType getEntityType() {
        if (IdentifiableType.RESOURCE == this.getType()) {
            return null;
        }
        switch (this.identifiableObjectType) {
            case CANYON: 
            case CAVE: 
            case CONTINENT: 
            case COUNTRY: 
            case CREEK: 
            case GEO_LOCATION: 
            case HUMAN_SETTLEMENT: 
            case LAKE: 
            case MOUNTAIN: 
            case OCEAN: 
            case RIVER: 
            case SEA: 
            case STILL_WATERS: 
            case VALLEY: {
                return EntityType.GEOLOCATION;
            }
        }
        return EntityType.valueOf(this.getIdentifiableObjectType().toString());
    }

    public LocalDate getNavDate() {
        return this.navDate;
    }

    public long getRefId() {
        return this.refId;
    }

    private boolean hasCustomAttribute(String attributeName) {
        return this.customAttributes != null && this.customAttributes.containsKey(attributeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.customAttributes, this.navDate, this.refId);
    }

    @Override
    protected void init() {
        super.init();
        this.type = IdentifiableType.ENTITY;
    }

    public void setCustomAttribute(String attributeName, Object attributeValue) {
        if (this.customAttributes == null) {
            this.customAttributes = new CustomAttributes();
        }
        this.customAttributes.put(attributeName, attributeValue);
    }

    public void setCustomAttributes(CustomAttributes customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setNavDate(LocalDate navDate) {
        this.navDate = navDate;
    }

    public void setRefId(long refId) {
        this.refId = refId;
    }

    protected Entity(EntityBuilder<?, ?> b) {
        super((Identifiable.IdentifiableBuilder<?, ?>)b);
        this.customAttributes = b.customAttributes;
        this.navDate = b.navDate;
        this.refId = b.refId;
    }

    public static EntityBuilder<?, ?> builder() {
        return new EntityBuilderImpl();
    }

    private static final class EntityBuilderImpl
    extends EntityBuilder<Entity, EntityBuilderImpl> {
        private EntityBuilderImpl() {
        }

        @Override
        protected EntityBuilderImpl self() {
            return this;
        }

        @Override
        public Entity prebuild() {
            return new Entity(this);
        }
    }

    public static abstract class EntityBuilder<C extends Entity, B extends EntityBuilder<C, B>>
    extends Identifiable.IdentifiableBuilder<C, B> {
        private CustomAttributes customAttributes;
        private LocalDate navDate;
        private long refId;

        @Override
        public C build() {
            Identifiable c = this.prebuild();
            ((Entity)c).init();
            return (C)c;
        }

        public B customAttribute(String key, Object value) {
            if (this.customAttributes == null) {
                this.customAttributes = new CustomAttributes();
            }
            this.customAttributes.put(key, value);
            return (B)this.self();
        }

        public B navDate(String navDate) {
            this.navDate = LocalDate.parse(navDate);
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B customAttributes(CustomAttributes customAttributes) {
            this.customAttributes = customAttributes;
            return (B)this.self();
        }

        public B refId(long refId) {
            this.refId = refId;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Entity.EntityBuilder(super=" + super.toString() + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + ")";
        }
    }
}

