/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.identifiable.versioning.Version;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.production.CreationInfo;
import java.util.ArrayList;
import java.util.List;

public class DigitalObject
extends Entity {
    private CreationInfo creationInfo;
    private List<FileResource> fileResources;
    private Item item;
    private License license;
    private List<LinkedDataFileResource> linkedDataResources;
    private int numberOfBinaryResources;
    private DigitalObject parent;
    private List<FileResource> renderingResources;
    private Version version;

    public DigitalObject() {
        this.init();
    }

    public void addFileResource(FileResource fileResource) {
        this.fileResources.add(fileResource);
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public List<FileResource> getFileResources() {
        return this.fileResources;
    }

    public Item getItem() {
        return this.item;
    }

    public License getLicense() {
        return this.license;
    }

    public List<LinkedDataFileResource> getLinkedDataResources() {
        return this.linkedDataResources;
    }

    public int getNumberOfBinaryResources() {
        return this.numberOfBinaryResources;
    }

    public DigitalObject getParent() {
        return this.parent;
    }

    public List<FileResource> getRenderingResources() {
        return this.renderingResources;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    protected void init() {
        super.init();
        if (this.fileResources == null) {
            this.fileResources = new ArrayList<FileResource>(0);
        }
        if (this.linkedDataResources == null) {
            this.linkedDataResources = new ArrayList<LinkedDataFileResource>(0);
        }
        if (this.renderingResources == null) {
            this.renderingResources = new ArrayList<FileResource>(0);
        }
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setFileResources(List<FileResource> fileResources) {
        this.fileResources = fileResources;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setLinkedDataResources(List<LinkedDataFileResource> linkedDataResources) {
        this.linkedDataResources = linkedDataResources;
    }

    public void setNumberOfBinaryResources(int numberOfBinaryResources) {
        this.numberOfBinaryResources = numberOfBinaryResources;
    }

    public void setParent(DigitalObject parent) {
        this.parent = parent;
    }

    public void setRenderingResources(List<FileResource> renderingResources) {
        this.renderingResources = renderingResources;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public String toString() {
        return "DigitalObject{created=" + this.created + ", description=" + this.description + ", identifiers=" + this.identifiers + ", label=" + this.label + ", lastModified=" + this.lastModified + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", item=" + this.item + ", parent=" + this.parent + ", fileResources=" + this.fileResources + ", linkeddataResources=" + this.linkedDataResources + ", renderingResources=" + this.renderingResources + ", numberOfBinaryResources=" + this.numberOfBinaryResources + ", license=" + this.license + ", version=" + this.version + ", creationInfo=" + this.creationInfo + ", customAttributes=" + this.customAttributes + ", navDate=" + this.navDate + ", refId=" + this.refId + "}";
    }

    protected DigitalObject(DigitalObjectBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.creationInfo = b.creationInfo;
        this.fileResources = b.fileResources;
        this.item = b.item;
        this.license = b.license;
        this.linkedDataResources = b.linkedDataResources;
        this.numberOfBinaryResources = b.numberOfBinaryResources;
        this.parent = b.parent;
        this.renderingResources = b.renderingResources;
        this.version = b.version;
    }

    public static DigitalObjectBuilder<?, ?> builder() {
        return new DigitalObjectBuilderImpl();
    }

    private static final class DigitalObjectBuilderImpl
    extends DigitalObjectBuilder<DigitalObject, DigitalObjectBuilderImpl> {
        private DigitalObjectBuilderImpl() {
        }

        @Override
        protected DigitalObjectBuilderImpl self() {
            return this;
        }

        @Override
        public DigitalObject prebuild() {
            return new DigitalObject(this);
        }
    }

    public static abstract class DigitalObjectBuilder<C extends DigitalObject, B extends DigitalObjectBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private CreationInfo creationInfo;
        private List<FileResource> fileResources;
        private Item item;
        private License license;
        private List<LinkedDataFileResource> linkedDataResources;
        private int numberOfBinaryResources;
        private DigitalObject parent;
        private List<FileResource> renderingResources;
        private Version version;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((DigitalObject)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B linkedDataFileResource(LinkedDataFileResource linkedDataFileResource) {
            if (this.linkedDataResources == null) {
                this.linkedDataResources = new ArrayList<LinkedDataFileResource>(0);
            }
            this.linkedDataResources.add(linkedDataFileResource);
            return (B)this.self();
        }

        public B renderingResource(FileResource renderingResource) {
            if (this.renderingResources == null) {
                this.renderingResources = new ArrayList<FileResource>(0);
            }
            this.renderingResources.add(renderingResource);
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B creationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return (B)this.self();
        }

        public B fileResources(List<FileResource> fileResources) {
            this.fileResources = fileResources;
            return (B)this.self();
        }

        public B item(Item item) {
            this.item = item;
            return (B)this.self();
        }

        public B license(License license) {
            this.license = license;
            return (B)this.self();
        }

        public B linkedDataResources(List<LinkedDataFileResource> linkedDataResources) {
            this.linkedDataResources = linkedDataResources;
            return (B)this.self();
        }

        public B numberOfBinaryResources(int numberOfBinaryResources) {
            this.numberOfBinaryResources = numberOfBinaryResources;
            return (B)this.self();
        }

        public B parent(DigitalObject parent) {
            this.parent = parent;
            return (B)this.self();
        }

        public B renderingResources(List<FileResource> renderingResources) {
            this.renderingResources = renderingResources;
            return (B)this.self();
        }

        public B version(Version version) {
            this.version = version;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DigitalObject.DigitalObjectBuilder(super=" + super.toString() + ", creationInfo=" + this.creationInfo + ", fileResources=" + this.fileResources + ", item=" + this.item + ", license=" + this.license + ", linkedDataResources=" + this.linkedDataResources + ", numberOfBinaryResources=" + this.numberOfBinaryResources + ", parent=" + this.parent + ", renderingResources=" + this.renderingResources + ", version=" + this.version + ")";
        }
    }
}

