/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.entity;

import de.digitalcollections.model.identifiable.INode;
import de.digitalcollections.model.identifiable.Node;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Collection
extends Entity
implements INode<Collection> {
    private List<Entity> entities;
    private Node<Collection> node;
    private LocalDate publicationEnd;
    private LocalDate publicationStart;
    private LocalizedStructuredContent text;

    public Collection() {
        this.init();
    }

    public void addEntity(Entity entity) {
        if (this.getEntities() == null) {
            this.setEntities(new ArrayList<Entity>(0));
        }
        this.getEntities().add(entity);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Collection that = (Collection)o;
        return Objects.equals(this.entities, that.entities) && Objects.equals(this.node, that.node) && Objects.equals(this.publicationEnd, that.publicationEnd) && Objects.equals(this.publicationStart, that.publicationStart) && Objects.equals(this.text, that.text);
    }

    @Override
    public List<Collection> getChildren() {
        return this.node.getChildren();
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public Node<Collection> getNode() {
        return this.node;
    }

    @Override
    public Collection getParent() {
        return this.node.getParent();
    }

    public LocalDate getPublicationEnd() {
        return this.publicationEnd;
    }

    public LocalDate getPublicationStart() {
        return this.publicationStart;
    }

    public LocalizedStructuredContent getText() {
        return this.text;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.entities, this.node, this.publicationEnd, this.publicationStart, this.text);
    }

    @Override
    protected void init() {
        super.init();
        if (this.node == null) {
            this.node = new Node();
        }
    }

    @Override
    public void setChildren(List<Collection> children) {
        this.node.setChildren(children);
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    @Override
    public void setParent(Collection parent) {
        this.node.setParent(parent);
    }

    public void setPublicationEnd(LocalDate publicationEnd) {
        this.publicationEnd = publicationEnd;
    }

    public void setPublicationStart(LocalDate publicationStart) {
        this.publicationStart = publicationStart;
    }

    public void setText(LocalizedStructuredContent text) {
        this.text = text;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{entities=" + this.entities + ", node=" + this.node + ", publicationEnd=" + this.publicationEnd + ", publicationStart=" + this.publicationStart + ", text=" + this.text + ", customAttributes=" + this.customAttributes + ", refId=" + this.refId + ", created=" + this.created + ", description=" + this.description + ", label=" + this.label + ", lastModified=" + this.lastModified + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", type=" + this.type + ", uuid=" + this.getUuid() + "}";
    }

    protected Collection(CollectionBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.entities = b.entities;
        this.node = b.node;
        this.publicationEnd = b.publicationEnd;
        this.publicationStart = b.publicationStart;
        this.text = b.text;
    }

    public static CollectionBuilder<?, ?> builder() {
        return new CollectionBuilderImpl();
    }

    private static final class CollectionBuilderImpl
    extends CollectionBuilder<Collection, CollectionBuilderImpl> {
        private CollectionBuilderImpl() {
        }

        @Override
        protected CollectionBuilderImpl self() {
            return this;
        }

        @Override
        public Collection prebuild() {
            return new Collection(this);
        }
    }

    public static abstract class CollectionBuilder<C extends Collection, B extends CollectionBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        private List<Entity> entities;
        private Node<Collection> node;
        private LocalDate publicationEnd;
        private LocalDate publicationStart;
        private LocalizedStructuredContent text;

        @Override
        public C build() {
            Entity c = this.prebuild();
            ((Collection)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B publicationEnd(String publicationEnd) {
            this.publicationEnd = LocalDate.parse(publicationEnd);
            return (B)this.self();
        }

        public B publicationStart(String publicationStart) {
            this.publicationStart = LocalDate.parse(publicationStart);
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B entities(List<Entity> entities) {
            this.entities = entities;
            return (B)this.self();
        }

        public B node(Node<Collection> node) {
            this.node = node;
            return (B)this.self();
        }

        public B text(LocalizedStructuredContent text) {
            this.text = text;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Collection.CollectionBuilder(super=" + super.toString() + ", entities=" + this.entities + ", node=" + this.node + ", publicationEnd=" + this.publicationEnd + ", publicationStart=" + this.publicationStart + ", text=" + this.text + ")";
        }
    }
}

