/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.alias;

import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.identifiable.entity.Website;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public class UrlAlias {
    private LocalDateTime created;
    private LocalDateTime lastPublished;
    private boolean primary;
    private String slug;
    private IdentifiableObjectType targetIdentifiableObjectType;
    private IdentifiableType targetIdentifiableType;
    private Locale targetLanguage;
    private UUID targetUuid;
    private UUID uuid;
    private Website website;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UrlAlias)) {
            return false;
        }
        UrlAlias other = (UrlAlias)obj;
        return Objects.equals(this.created, other.created) && Objects.equals(this.lastPublished, other.lastPublished) && this.primary == other.primary && Objects.equals(this.slug, other.slug) && Objects.equals(this.targetLanguage, other.targetLanguage) && Objects.equals((Object)this.targetIdentifiableObjectType, (Object)other.targetIdentifiableObjectType) && Objects.equals((Object)this.targetIdentifiableType, (Object)other.targetIdentifiableType) && Objects.equals(this.targetUuid, other.targetUuid) && Objects.equals(this.uuid, other.uuid) && Objects.equals(this.website != null ? this.website.getUuid() : null, other.website != null ? other.website.getUuid() : null);
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public LocalDateTime getLastPublished() {
        return this.lastPublished;
    }

    public String getSlug() {
        return this.slug;
    }

    @Deprecated(forRemoval=true, since="10.0.0")
    public EntityType getTargetEntityType() {
        if (IdentifiableType.RESOURCE == this.targetIdentifiableType) {
            return null;
        }
        switch (this.targetIdentifiableObjectType) {
            case CANYON: 
            case CAVE: 
            case CONTINENT: 
            case COUNTRY: 
            case CREEK: 
            case GEO_LOCATION: 
            case HUMAN_SETTLEMENT: 
            case LAKE: 
            case MOUNTAIN: 
            case OCEAN: 
            case RIVER: 
            case SEA: 
            case STILL_WATERS: 
            case VALLEY: {
                return EntityType.GEOLOCATION;
            }
        }
        return EntityType.valueOf(this.targetIdentifiableObjectType.toString());
    }

    public IdentifiableObjectType getTargetIdentifiableObjectType() {
        return this.targetIdentifiableObjectType;
    }

    public IdentifiableType getTargetIdentifiableType() {
        return this.targetIdentifiableType;
    }

    public Locale getTargetLanguage() {
        return this.targetLanguage;
    }

    public UUID getTargetUuid() {
        return this.targetUuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Website getWebsite() {
        return this.website;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.lastPublished, this.primary, this.slug, this.targetLanguage, this.targetIdentifiableObjectType, this.targetIdentifiableType, this.targetUuid, this.uuid, this.website});
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public void setLastPublished(LocalDateTime lastPublished) {
        this.lastPublished = lastPublished;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setTargetIdentifiableObjectType(IdentifiableObjectType targetIdentifiableObjectType) {
        this.targetIdentifiableObjectType = targetIdentifiableObjectType;
    }

    public void setTargetIdentifiableType(IdentifiableType identifiableType) {
        this.targetIdentifiableType = identifiableType;
    }

    public void setTargetLanguage(Locale targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public void setTargetUuid(UUID targetUuid) {
        this.targetUuid = targetUuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setWebsite(Website website) {
        this.website = website;
    }

    public String toString() {
        return "UrlAlias{created=" + this.created + ", lastPublished=" + this.lastPublished + ", primary=" + this.primary + ", slug='" + this.slug + "', targetIdentifiableObjectType=" + this.targetIdentifiableObjectType + ", targetIdentifiableType=" + this.targetIdentifiableType + ", targetLanguage=" + this.targetLanguage + ", targetUuid=" + this.targetUuid + ", uuid=" + this.uuid + ", website=" + this.website + "}";
    }

    public static class Builder {
        UrlAlias urlAlias = new UrlAlias();

        public UrlAlias build() {
            return this.urlAlias;
        }

        public Builder created(String created) {
            this.urlAlias.setCreated(LocalDateTime.parse(created));
            return this;
        }

        public Builder isPrimary() {
            this.urlAlias.setPrimary(true);
            return this;
        }

        public Builder lastPublished(String lastPublished) {
            this.urlAlias.setLastPublished(LocalDateTime.parse(lastPublished));
            return this;
        }

        public Builder slug(String slug) {
            this.urlAlias.setSlug(slug);
            return this;
        }

        public Builder targetLanguage(Locale targetLanguage) {
            this.urlAlias.setTargetLanguage(targetLanguage);
            return this;
        }

        public Builder targetLanguage(String targetLanguage) {
            this.urlAlias.setTargetLanguage(Locale.forLanguageTag(targetLanguage));
            return this;
        }

        public Builder targetType(IdentifiableObjectType identifiableObjectType, IdentifiableType identifiableType) {
            this.urlAlias.setTargetIdentifiableObjectType(identifiableObjectType);
            this.urlAlias.setTargetIdentifiableType(identifiableType);
            return this;
        }

        public Builder targetUuid(String targetUuid) {
            this.urlAlias.setTargetUuid(UUID.fromString(targetUuid));
            return this;
        }

        public Builder uuid(String uuid) {
            this.urlAlias.setUuid(UUID.fromString(uuid));
            return this;
        }

        public Builder website(Website website) {
            this.urlAlias.setWebsite(website);
            return this;
        }
    }
}

