/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable.alias;

import de.digitalcollections.model.identifiable.alias.UrlAlias;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class LocalizedUrlAliases
extends HashMap<Locale, List<UrlAlias>> {
    public LocalizedUrlAliases() {
    }

    public LocalizedUrlAliases(UrlAlias ... urlAliases) {
        this.add(urlAliases);
    }

    public LocalizedUrlAliases(List<UrlAlias> urlAliases) {
        this((UrlAlias[])urlAliases.toArray(UrlAlias[]::new));
    }

    public void add(UrlAlias ... urlAliases) {
        if (urlAliases == null) {
            return;
        }
        for (UrlAlias urlAlias : urlAliases) {
            if (urlAlias == null) continue;
            this.compute(urlAlias.getTargetLanguage(), (locale, listOfAliases) -> {
                if (listOfAliases == null) {
                    listOfAliases = new ArrayList<UrlAlias>();
                }
                listOfAliases.add(urlAlias);
                return listOfAliases;
            });
        }
    }

    public boolean containsUrlAlias(UrlAlias urlAlias) {
        return this.flatten().contains(urlAlias);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof LocalizedUrlAliases)) {
            return false;
        }
        LocalizedUrlAliases other = (LocalizedUrlAliases)o;
        try {
            if (this.flatten().size() != other.flatten().size()) {
                return false;
            }
            return this.flatten().containsAll(other.flatten());
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    public List<UrlAlias> flatten() {
        return this.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    public List<Locale> getTargetLanguages() {
        return new ArrayList<Locale>(this.keySet());
    }

    public boolean hasTargetLanguage(Locale locale) {
        return this.containsKey(locale);
    }
}

