/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable;

import de.digitalcollections.model.UniqueObject;
import java.util.UUID;

public class IdentifierType
extends UniqueObject {
    private String label;
    private String namespace;
    private String pattern;

    public static Builder builder() {
        return new Builder();
    }

    public String getLabel() {
        return this.label;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public static class Builder {
        public IdentifierType identifierType = new IdentifierType();

        public IdentifierType build() {
            return this.identifierType;
        }

        public Builder label(String label) {
            this.identifierType.setLabel(label);
            return this;
        }

        public Builder namespace(String namespace) {
            this.identifierType.setNamespace(namespace);
            return this;
        }

        public Builder pattern(String pattern) {
            this.identifierType.setPattern(pattern);
            return this;
        }

        public Builder uuid(String uuid) {
            this.identifierType.setUuid(UUID.fromString(uuid));
            return this;
        }
    }
}

