/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.identifiable;

import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.StructuredContent;
import de.digitalcollections.model.text.contentblock.Paragraph;
import de.digitalcollections.model.view.RenderingHintsPreviewImage;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class Identifiable
extends UniqueObject {
    protected LocalizedStructuredContent description;
    protected IdentifiableObjectType identifiableObjectType;
    protected Set<Identifier> identifiers;
    protected LocalizedText label;
    protected LocalizedUrlAliases localizedUrlAliases;
    protected ImageFileResource previewImage;
    protected RenderingHintsPreviewImage previewImageRenderingHints;
    protected IdentifiableType type;

    public Identifiable() {
        this.init();
    }

    public void addIdentifier(Identifier identifier) {
        this.identifiers.add(Objects.requireNonNull(identifier));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Identifiable)) {
            return false;
        }
        Identifiable that = (Identifiable)o;
        return super.equals(o) && Objects.equals(this.description, that.description) && this.identifiableObjectType == that.identifiableObjectType && Objects.equals(this.identifiers, that.identifiers) && Objects.equals(this.label, that.label) && Objects.equals(this.localizedUrlAliases, that.localizedUrlAliases) && Objects.equals(this.previewImage, that.previewImage) && Objects.equals(this.previewImageRenderingHints, that.previewImageRenderingHints) && this.type == that.type;
    }

    public LocalizedStructuredContent getDescription() {
        return this.description;
    }

    public IdentifiableObjectType getIdentifiableObjectType() {
        return this.identifiableObjectType;
    }

    public Identifier getIdentifierByNamespace(String namespace) {
        if (namespace == null || this.identifiers == null || this.identifiers.isEmpty()) {
            return null;
        }
        for (Identifier identifier : this.identifiers) {
            if (!namespace.equals(identifier.getNamespace())) continue;
            return identifier;
        }
        return null;
    }

    public Set<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public LocalizedText getLabel() {
        return this.label;
    }

    public LocalizedUrlAliases getLocalizedUrlAliases() {
        return this.localizedUrlAliases;
    }

    public ImageFileResource getPreviewImage() {
        return this.previewImage;
    }

    public RenderingHintsPreviewImage getPreviewImageRenderingHints() {
        return this.previewImageRenderingHints;
    }

    public UrlAlias getPrimaryUrlAlias(Locale locale, Website website) {
        UrlAlias urlAlias;
        if (this.localizedUrlAliases == null || this.localizedUrlAliases.isEmpty()) {
            return null;
        }
        List urlAliases = (List)this.localizedUrlAliases.get(Locale.forLanguageTag(locale.getLanguage()));
        if (urlAliases == null || urlAliases.isEmpty()) {
            return null;
        }
        Supplier<Stream> primaries = () -> urlAliases.stream().filter(u -> u.isPrimary());
        if (website != null && (urlAlias = (UrlAlias)primaries.get().filter(u -> u.getWebsite() != null && u.getWebsite().getUuid().equals(website.getUuid())).findFirst().orElse(null)) != null) {
            return urlAlias;
        }
        return primaries.get().filter(u -> u.getWebsite() == null).findFirst().orElse(null);
    }

    public IdentifiableType getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(new Object[]{this.description, this.identifiableObjectType, this.identifiers, this.label, this.localizedUrlAliases, this.previewImage, this.previewImageRenderingHints, this.type});
    }

    @Override
    protected void init() {
        super.init();
        this.identifiableObjectType = IdentifiableObjectType.getByClass(this.getClass());
        if (this.identifiers == null) {
            this.identifiers = new HashSet<Identifier>(0);
        }
    }

    public void setDescription(LocalizedStructuredContent description) {
        this.description = description;
    }

    public void setIdentifiableObjectType(IdentifiableObjectType identifiableObjectType) {
        this.identifiableObjectType = identifiableObjectType;
    }

    public void setIdentifiers(Set<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public void setLabel(String label) {
        this.label = new LocalizedText(Locale.ROOT, label);
    }

    public void setLabel(LocalizedText label) {
        this.label = label;
    }

    public void setLocalizedUrlAliases(LocalizedUrlAliases localizedUrlAliases) {
        this.localizedUrlAliases = localizedUrlAliases;
    }

    public void setPreviewImage(ImageFileResource previewImage) {
        this.previewImage = previewImage;
    }

    public void setPreviewImageRenderingHints(RenderingHintsPreviewImage previewImageRenderingHints) {
        this.previewImageRenderingHints = previewImageRenderingHints;
    }

    public void setType(IdentifiableType identifiableType) {
        this.type = identifiableType;
    }

    protected Identifiable(IdentifiableBuilder<?, ?> b) {
        super(b);
        this.description = b.description;
        this.identifiableObjectType = b.identifiableObjectType;
        this.identifiers = b.identifiers;
        this.label = b.label;
        this.localizedUrlAliases = b.localizedUrlAliases;
        this.previewImage = b.previewImage;
        this.previewImageRenderingHints = b.previewImageRenderingHints;
        this.type = b.type;
    }

    public static IdentifiableBuilder<?, ?> builder() {
        return new IdentifiableBuilderImpl();
    }

    private static final class IdentifiableBuilderImpl
    extends IdentifiableBuilder<Identifiable, IdentifiableBuilderImpl> {
        private IdentifiableBuilderImpl() {
        }

        @Override
        protected IdentifiableBuilderImpl self() {
            return this;
        }

        @Override
        public Identifiable prebuild() {
            return new Identifiable(this);
        }
    }

    public static abstract class IdentifiableBuilder<C extends Identifiable, B extends IdentifiableBuilder<C, B>>
    extends UniqueObject.UniqueObjectBuilder<C, B> {
        private LocalizedStructuredContent description;
        private IdentifiableObjectType identifiableObjectType;
        private LocalizedText label;
        private LocalizedUrlAliases localizedUrlAliases;
        private ImageFileResource previewImage;
        private RenderingHintsPreviewImage previewImageRenderingHints;
        private IdentifiableType type;
        private Set<Identifier> identifiers;

        public B altText(Locale locale, String text) {
            LocalizedText altText;
            if (this.previewImageRenderingHints == null) {
                this.previewImageRenderingHints = new RenderingHintsPreviewImage();
            }
            if ((altText = this.previewImageRenderingHints.getAltText()) == null) {
                altText = new LocalizedText();
            }
            altText.setText(locale, text);
            this.previewImageRenderingHints.setAltText(altText);
            return (B)this.self();
        }

        public B altTextFromLabel() {
            if (this.previewImageRenderingHints == null) {
                this.previewImageRenderingHints = new RenderingHintsPreviewImage();
            }
            this.previewImageRenderingHints.setAltText(this.label);
            return (B)this.self();
        }

        @Override
        public C build() {
            UniqueObject c = this.prebuild();
            ((Identifiable)c).init();
            this.setInternalReferences(c);
            return (C)c;
        }

        public B description(Locale locale, String text) {
            StructuredContent localizedDescription;
            if (this.description == null) {
                this.description = new LocalizedStructuredContent();
            }
            if ((localizedDescription = (StructuredContent)this.description.get(locale)) == null) {
                localizedDescription = new StructuredContent();
            }
            Paragraph paragraph = StringUtils.hasText((String)text) ? new Paragraph(text) : new Paragraph();
            localizedDescription.addContentBlock(paragraph);
            this.description.put(locale, localizedDescription);
            return (B)this.self();
        }

        public B description(String lang, String text) {
            return this.description(Locale.forLanguageTag(lang), text);
        }

        public B dontOpenPreviewImageInNewWindow() {
            if (this.previewImageRenderingHints == null) {
                this.previewImageRenderingHints = new RenderingHintsPreviewImage();
            }
            this.previewImageRenderingHints.setOpenLinkInNewWindow(false);
            return (B)this.self();
        }

        public B identifier(Identifier identifier) {
            if (this.identifiers == null) {
                this.identifiers = new HashSet<Identifier>(0);
            }
            this.identifiers.add(identifier);
            return (B)this.self();
        }

        public B identifier(String namespace, String id, String uuid) {
            if (this.identifiers == null) {
                this.identifiers = new HashSet<Identifier>(0);
            }
            Identifier identifier = new Identifier();
            identifier.setNamespace(namespace);
            identifier.setId(id);
            if (uuid != null) {
                identifier.setUuid(UUID.fromString(uuid));
            }
            identifier.setIdentifiable(super.getUuid());
            this.identifiers.add(identifier);
            return (B)this.self();
        }

        public B identifier(String namespace, String id) {
            return this.identifier(namespace, id, null);
        }

        public B label(Locale locale, String localizedLabel) {
            if (this.label == null) {
                this.label = new LocalizedText();
            }
            this.label.setText(locale, localizedLabel);
            return (B)this.self();
        }

        public B label(String nonlocalizedLabel) {
            this.label = new LocalizedText(Locale.ROOT, nonlocalizedLabel);
            return (B)this.self();
        }

        public B openLinkInNewWindow() {
            return this.openPreviewImageInNewWindow();
        }

        public B openPreviewImageInNewWindow() {
            if (this.previewImageRenderingHints == null) {
                this.previewImageRenderingHints = new RenderingHintsPreviewImage();
            }
            this.previewImageRenderingHints.setOpenLinkInNewWindow(true);
            return (B)this.self();
        }

        public B previewImage(ImageFileResource previewImage) {
            this.previewImage = previewImage;
            return (B)this.self();
        }

        public B previewImage(String url, int width, int height) {
            String[] fileNameParts = url.split("/\\//");
            return this.previewImage(ImageFileResource.previewImageBuilder().fileName(fileNameParts[fileNameParts.length - 1]).uri(url).size(width, height).build());
        }

        public B previewImage(String fileName, String uuid, String uri) {
            return this.previewImage(ImageFileResource.previewImageBuilder().uuid(uuid).fileName(fileName).uri(uri).build());
        }

        public B previewImage(String fileName, String uuid, String uri, MimeType mimeType) {
            return this.previewImage(ImageFileResource.previewImageBuilder().uuid(uuid).fileName(fileName).uri(uri).mimeType(mimeType).build());
        }

        public B previewImage(String fileName, String uuid, String uri, MimeType mimeType, String httpBaseUrl) {
            return this.previewImage(ImageFileResource.previewImageBuilder().uuid(uuid).fileName(fileName).uri(uri).mimeType(mimeType).httpBaseUrl(httpBaseUrl).build());
        }

        public B primaryLocalizedUrlAlias(String slug) {
            this.localizedUrlAliases = new LocalizedUrlAliases(UrlAlias.builder().slug(slug).isPrimary().build());
            return (B)this.self();
        }

        public void setInternalReferences(C c) {
            if (this.identifiers != null && !this.identifiers.isEmpty()) {
                ((Identifiable)c).setIdentifiers(this.identifiers.stream().peek(i -> i.setIdentifiable(c.getUuid())).collect(Collectors.toSet()));
            } else {
                ((Identifiable)c).setIdentifiers(new HashSet<Identifier>(0));
            }
            if (((Identifiable)c).getLocalizedUrlAliases() != null && !((Identifiable)c).getLocalizedUrlAliases().isEmpty()) {
                ((Identifiable)c).getLocalizedUrlAliases().forEach((locale, urlAliasList) -> urlAliasList.forEach(u -> u.setTargetUuid(c.getUuid())));
            }
        }

        public B title(Locale locale, String text) {
            LocalizedText title;
            if (this.previewImageRenderingHints == null) {
                this.previewImageRenderingHints = new RenderingHintsPreviewImage();
            }
            if ((title = this.previewImageRenderingHints.getTitle()) == null) {
                title = new LocalizedText();
            }
            title.setText(locale, text);
            this.previewImageRenderingHints.setTitle(title);
            return (B)this.self();
        }

        public B titleFromLabel() {
            if (this.previewImageRenderingHints == null) {
                this.previewImageRenderingHints = new RenderingHintsPreviewImage();
            }
            this.previewImageRenderingHints.setTitle(this.label);
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C prebuild();

        public B identifiableObjectType(IdentifiableObjectType identifiableObjectType) {
            this.identifiableObjectType = identifiableObjectType;
            return (B)this.self();
        }

        public B identifiers(Set<Identifier> identifiers) {
            this.identifiers = identifiers;
            return (B)this.self();
        }

        public B localizedUrlAliases(LocalizedUrlAliases localizedUrlAliases) {
            this.localizedUrlAliases = localizedUrlAliases;
            return (B)this.self();
        }

        public B previewImageRenderingHints(RenderingHintsPreviewImage previewImageRenderingHints) {
            this.previewImageRenderingHints = previewImageRenderingHints;
            return (B)this.self();
        }

        public B type(IdentifiableType type) {
            this.type = type;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Identifiable.IdentifiableBuilder(super=" + super.toString() + ", description=" + this.description + ", identifiableObjectType=" + this.identifiableObjectType + ", identifiers=" + this.identifiers + ", label=" + this.label + ", localizedUrlAliases=" + this.localizedUrlAliases + ", previewImage=" + this.previewImage + ", previewImageRenderingHints=" + this.previewImageRenderingHints + ", type=" + this.type + ")";
        }
    }
}

