/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

public abstract class UniqueObject {
    protected LocalDateTime created;
    protected LocalDateTime lastModified;
    protected UUID uuid;

    public UniqueObject() {
        this.init();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UniqueObject)) {
            return false;
        }
        UniqueObject other = (UniqueObject)obj;
        return Objects.equals(this.created, other.created) && Objects.equals(this.lastModified, other.lastModified) && Objects.equals(this.uuid, other.uuid);
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int hashCode() {
        return Objects.hash(this.created, this.lastModified, this.uuid);
    }

    protected void init() {
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public void setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    protected UniqueObject(UniqueObjectBuilder<?, ?> b) {
        this.created = b.created;
        this.lastModified = b.lastModified;
        this.uuid = b.uuid;
    }

    public static abstract class UniqueObjectBuilder<C extends UniqueObject, B extends UniqueObjectBuilder<C, B>> {
        private LocalDateTime created;
        private LocalDateTime lastModified;
        private UUID uuid;

        public C build() {
            C c = this.prebuild();
            ((UniqueObject)c).init();
            return c;
        }

        public B created(String created) {
            this.created = LocalDateTime.parse(created);
            return this.self();
        }

        public B created(LocalDateTime created) {
            this.created = created;
            return this.self();
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public B lastModified(String lastModified) {
            this.lastModified = LocalDateTime.parse(lastModified);
            return this.self();
        }

        public B lastModified(LocalDateTime lastModified) {
            this.lastModified = lastModified;
            return this.self();
        }

        public B randomUuid() {
            this.uuid = UUID.randomUUID();
            return this.self();
        }

        public B uuid(String uuid) {
            this.uuid = UUID.fromString(uuid);
            return this.self();
        }

        public B uuid(UUID uuid) {
            this.uuid = uuid;
            return this.self();
        }

        protected abstract B self();

        public abstract C prebuild();

        public String toString() {
            return "UniqueObject.UniqueObjectBuilder(created=" + this.created + ", lastModified=" + this.lastModified + ", uuid=" + this.uuid + ")";
        }
    }
}

