/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.mappings.html;

import de.digitalcollections.model.text.StructuredContent;
import de.digitalcollections.model.text.contentblock.BulletList;
import de.digitalcollections.model.text.contentblock.ContentBlock;
import de.digitalcollections.model.text.contentblock.ContentBlockNode;
import de.digitalcollections.model.text.contentblock.ContentBlockNodeWithAttributes;
import de.digitalcollections.model.text.contentblock.HardBreak;
import de.digitalcollections.model.text.contentblock.ListItem;
import de.digitalcollections.model.text.contentblock.Mark;
import de.digitalcollections.model.text.contentblock.Table;
import de.digitalcollections.model.text.contentblock.TableCell;
import de.digitalcollections.model.text.contentblock.TableHeader;
import de.digitalcollections.model.text.contentblock.TableRow;
import de.digitalcollections.model.text.contentblock.Text;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;

public class HtmlMapper {
    private static void addTableCellAttributes(Element element, ContentBlockNodeWithAttributes tableBlock) {
        String colwidth;
        String rowspan;
        String colspan = element.attr("colspan");
        if (!colspan.isBlank()) {
            tableBlock.addAttribute("colspan", (Object)Integer.valueOf(colspan));
        }
        if (!(rowspan = element.attr("rowspan")).isBlank()) {
            tableBlock.addAttribute("rowspan", (Object)Integer.valueOf(rowspan));
        }
        if (!(colwidth = element.attr("colwidth")).isBlank()) {
            tableBlock.addAttribute("colwidth", (Object)Integer.valueOf(colwidth));
        }
    }

    public static ContentBlock getContentBlock(Node node) {
        Text contentBlock = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            String tagName = element.tagName();
            if ("ul".equalsIgnoreCase(tagName)) {
                contentBlock = new BulletList();
            } else if ("li".equalsIgnoreCase(tagName)) {
                contentBlock = new ListItem();
            } else if ("table".equalsIgnoreCase(tagName)) {
                contentBlock = new Table();
            } else if ("tr".equalsIgnoreCase(tagName)) {
                contentBlock = new TableRow();
            } else if ("th".equalsIgnoreCase(tagName)) {
                contentBlock = new TableHeader();
                HtmlMapper.addTableCellAttributes(element, (ContentBlockNodeWithAttributes)contentBlock);
            } else if ("td".equalsIgnoreCase(tagName)) {
                contentBlock = new TableCell();
                HtmlMapper.addTableCellAttributes(element, (ContentBlockNodeWithAttributes)contentBlock);
            } else if ("br".equalsIgnoreCase(tagName)) {
                contentBlock = new HardBreak();
            } else if ("a".equalsIgnoreCase(tagName)) {
                String text = element.text();
                contentBlock = new Text(text);
                String href = element.attr("href");
                Mark link = new Mark("link");
                link.addAttribute("href", (Object)href);
                contentBlock.addMark(link);
            } else {
                throw new UnsupportedOperationException("Not yet implemented: getContentBlock() for HTML element " + tagName);
            }
            if (contentBlock instanceof ContentBlockNode && element.childNodeSize() > 0) {
                List children = element.childNodes();
                for (Node child : children) {
                    ContentBlock childContentBlock = HtmlMapper.getContentBlock(child);
                    ((ContentBlockNode)contentBlock).addContentBlock(childContentBlock);
                }
            }
        } else if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            contentBlock = new Text(textNode.text());
        }
        return contentBlock;
    }

    public static StructuredContent toStructuredContent(String html) {
        return HtmlMapper.toStructuredContent(html, Parser.htmlParser());
    }

    public static StructuredContent toStructuredContent(String html, Parser parser) {
        StructuredContent structuredContent = new StructuredContent();
        Document doc = Jsoup.parse((String)html, (Parser)parser);
        Element body = doc.body();
        List childNodes = body.childNodes();
        for (Node childNode : childNodes) {
            ContentBlock contentBlock = HtmlMapper.getContentBlock(childNode);
            structuredContent.addContentBlock(contentBlock);
        }
        return structuredContent;
    }
}

