/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.model.mappings.html;

import de.digitalcollections.model.text.StructuredContent;
import de.digitalcollections.model.text.contentblock.BulletList;
import de.digitalcollections.model.text.contentblock.ContentBlock;
import de.digitalcollections.model.text.contentblock.ContentBlockNode;
import de.digitalcollections.model.text.contentblock.ListItem;
import de.digitalcollections.model.text.contentblock.Mark;
import de.digitalcollections.model.text.contentblock.Text;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class HtmlMapper {
    public static ContentBlock getContentBlock(Node node) {
        Text contentBlock = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            String tagName = element.tagName();
            if ("ul".equalsIgnoreCase(tagName)) {
                contentBlock = new BulletList();
            } else if ("li".equalsIgnoreCase(tagName)) {
                contentBlock = new ListItem();
            } else if ("a".equalsIgnoreCase(tagName)) {
                String text = element.text();
                contentBlock = new Text(text);
                String href = element.attr("href");
                Mark link = new Mark("link");
                link.addAttribute("href", (Object)href);
                contentBlock.addMark(link);
            } else {
                throw new UnsupportedOperationException("Not yet implemented: getContentBlock() for HTML element " + tagName);
            }
            if (contentBlock instanceof ContentBlockNode && element.childNodeSize() > 0) {
                List children = element.childNodes();
                for (Node child : children) {
                    ContentBlock childContentBlock = HtmlMapper.getContentBlock(child);
                    ((ContentBlockNode)contentBlock).addContentBlock(childContentBlock);
                }
            }
        } else if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            contentBlock = new Text(textNode.text());
        }
        return contentBlock;
    }

    public static StructuredContent toStructuredContent(String html) {
        StructuredContent structuredContent = new StructuredContent();
        Document doc = Jsoup.parse((String)html);
        Element body = doc.body();
        List childNodes = body.childNodes();
        for (Node childNode : childNodes) {
            ContentBlock contentBlock = HtmlMapper.getContentBlock(childNode);
            structuredContent.addContentBlock(contentBlock);
        }
        return structuredContent;
    }
}

