/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.turbojpeg;

import de.digitalcollections.turbojpeg.lib.enums.TJCS;
import de.digitalcollections.turbojpeg.lib.enums.TJSAMP;
import de.digitalcollections.turbojpeg.lib.structs.tjscalingfactor;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class Info {
    private int width;
    private int height;
    private TJSAMP subsampling;
    private TJCS colorspace;
    List<Dimension> availableSizes;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TJSAMP getSubsampling() {
        return this.subsampling;
    }

    public TJCS getColorspace() {
        return this.colorspace;
    }

    public List<Dimension> getAvailableSizes() {
        return this.availableSizes;
    }

    private static int getScaled(int dim, int num, int denom) {
        return (dim * num + denom - 1) / denom;
    }

    public Info(int width, int height, int subsampling, int colorspace, tjscalingfactor[] factors) {
        this.width = width;
        this.height = height;
        this.subsampling = TJSAMP.fromInt(subsampling);
        this.colorspace = TJCS.fromInt(colorspace);
        this.availableSizes = Arrays.stream(factors).filter(f -> f.denom.get() > 0).sorted(Comparator.comparing(f -> -Info.getScaled(width, f.num.get(), f.denom.get()))).map(f -> new Dimension(Info.getScaled(width, f.num.get(), f.denom.get()), Info.getScaled(height, f.num.get(), f.denom.get()))).filter(d -> d.width <= width && d.height <= height && d.width > 0 && d.height > 0).distinct().collect(Collectors.toList());
    }

    public Dimension getMCUSize() {
        switch (this.subsampling) {
            case TJSAMP_422: {
                return new Dimension(16, 8);
            }
            case TJSAMP_420: {
                return new Dimension(16, 16);
            }
            case TJSAMP_440: {
                return new Dimension(8, 16);
            }
        }
        return new Dimension(8, 8);
    }
}

