/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.turbojpeg.imageio;

import de.digitalcollections.turbojpeg.TurboJpeg;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurboJpegImageReaderSpi
extends ImageReaderSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurboJpegImageReaderSpi.class);
    private static byte[] HEADER_MAGIC = new byte[]{-1, -40};
    private static final String vendorName = "M\u00fcnchener Digitalisierungszentrum/Digitale Bibliothek, Bayerische Staatsbibliothek";
    private static final String version = "0.2.6";
    private static final String readerClassName = "de.digitalcollections.openjpeg.turbojpeg.TurboJpegImageReader";
    private static final String[] names = new String[]{"JPEG", "jpeg", "JPG", "jpg"};
    private static final String[] suffixes = new String[]{"jpg", "jpeg"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String[] writerSpiNames = new String[]{"de.digitalcollections.turbojpeg.imageio.TurboJpegImageWriterSpi"};
    private TurboJpeg lib;

    public TurboJpegImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, new Class[]{ImageInputStream.class}, writerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    private void loadLibrary() throws IOException {
        if (this.lib == null) {
            try {
                this.lib = new TurboJpeg();
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.warn("Could not load libturbojpeg, plugin will be disabled");
                throw new IOException(e);
            }
        }
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        Stream.of("com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReaderSpi", "com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi").forEach(clsName -> {
            try {
                ImageReaderSpi defaultProvider = (ImageReaderSpi)registry.getServiceProviderByClass(Class.forName(clsName));
                registry.setOrdering(category, this, defaultProvider);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        this.loadLibrary();
        if (!(input instanceof ImageInputStream)) {
            input = ImageIO.createImageInputStream(input);
        }
        if (input == null) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)input;
        byte[] b = new byte[2];
        try {
            stream.mark();
            stream.readFully(b);
        }
        catch (IOException e) {
            return false;
        }
        return Arrays.equals(b, HEADER_MAGIC);
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        this.loadLibrary();
        return new TurboJpegImageReader(this, this.lib);
    }

    @Override
    public String getDescription(Locale locale) {
        return "JPEG reader plugin based on libjpeg-turbo/turbojpeg.";
    }
}

