/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.turbojpeg;

import de.digitalcollections.turbojpeg.Info;
import de.digitalcollections.turbojpeg.TurboJpegException;
import de.digitalcollections.turbojpeg.lib.enums.TJPF;
import de.digitalcollections.turbojpeg.lib.enums.TJSAMP;
import de.digitalcollections.turbojpeg.lib.enums.TJXOP;
import de.digitalcollections.turbojpeg.lib.enums.TJXOPT;
import de.digitalcollections.turbojpeg.lib.libturbojpeg;
import de.digitalcollections.turbojpeg.lib.structs.tjscalingfactor;
import de.digitalcollections.turbojpeg.lib.structs.tjtransform;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jnr.ffi.LibraryLoader;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.byref.IntByReference;
import jnr.ffi.byref.NativeLongByReference;
import jnr.ffi.byref.PointerByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurboJpeg {
    private static final Logger LOG = LoggerFactory.getLogger(TurboJpeg.class);
    public libturbojpeg lib = (libturbojpeg)LibraryLoader.create(libturbojpeg.class).load("turbojpeg");
    public Runtime runtime = Runtime.getRuntime((Object)this.lib);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo(byte[] jpegData) throws TurboJpegException {
        Pointer codec = null;
        try {
            codec = this.lib.tjInitDecompress();
            IntByReference width = new IntByReference();
            IntByReference height = new IntByReference();
            IntByReference jpegSubsamp = new IntByReference();
            int rv = this.lib.tjDecompressHeader2(codec, ByteBuffer.wrap(jpegData), jpegData.length, width, height, jpegSubsamp);
            if (rv != 0) {
                throw new TurboJpegException(this.lib.tjGetErrorStr());
            }
            IntByReference numRef = new IntByReference();
            Pointer factorPtr = this.lib.tjGetScalingFactors(numRef);
            Integer numOfFactors = (Integer)numRef.getValue();
            tjscalingfactor[] factors = new tjscalingfactor[numOfFactors.intValue()];
            for (int i = 0; i < numOfFactors; ++i) {
                tjscalingfactor f = new tjscalingfactor(this.runtime);
                factorPtr = factorPtr.slice((long)Struct.size((Struct)f));
                f.useMemory(factorPtr);
                factors[i] = f;
            }
            Info info = new Info((Integer)width.getValue(), (Integer)height.getValue(), (Integer)jpegSubsamp.getValue(), factors);
            return info;
        }
        finally {
            if (codec != null && codec.address() != 0L) {
                this.lib.tjDestroy(codec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage decode(byte[] jpegData, Info info, Dimension size) throws TurboJpegException {
        Pointer codec = null;
        try {
            codec = this.lib.tjInitDecompress();
            int width = info.getWidth();
            int height = info.getHeight();
            if (size != null) {
                if (!info.getAvailableSizes().contains(size)) {
                    throw new IllegalArgumentException(String.format("Invalid size, must be one of %s", info.getAvailableSizes()));
                }
                width = size.width;
                height = size.height;
            }
            boolean isGray = info.getSubsampling() == TJSAMP.TJSAMP_GRAY.intValue();
            int imgType = isGray ? 10 : 5;
            BufferedImage img = new BufferedImage(width, height, imgType);
            ByteBuffer outBuf = ByteBuffer.wrap(((DataBufferByte)img.getRaster().getDataBuffer()).getData()).order(this.runtime.byteOrder());
            int rv = this.lib.tjDecompress2(codec, ByteBuffer.wrap(jpegData), jpegData.length, outBuf, width, isGray ? width : width * 3, height, isGray ? TJPF.TJPF_GRAY : TJPF.TJPF_BGR, 0);
            if (rv != 0) {
                LOG.error("Could not decompress JPEG (dimensions: {}x{}, gray: {})", new Object[]{width, height, isGray});
                throw new TurboJpegException(this.lib.tjGetErrorStr());
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        finally {
            if (codec != null && codec.address() != 0L) {
                this.lib.tjDestroy(codec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer encode(Raster img, int quality) throws TurboJpegException {
        ByteBuffer byteBuffer;
        Pointer codec = null;
        Pointer bufPtr = null;
        try {
            TJPF pixelFmt;
            switch (img.getNumBands()) {
                case 4: {
                    pixelFmt = TJPF.TJPF_BGRX;
                    break;
                }
                case 3: {
                    pixelFmt = TJPF.TJPF_BGR;
                    break;
                }
                case 1: {
                    pixelFmt = TJPF.TJPF_GRAY;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal sample format");
                }
            }
            TJSAMP sampling = pixelFmt == TJPF.TJPF_GRAY ? TJSAMP.TJSAMP_GRAY : TJSAMP.TJSAMP_420;
            codec = this.lib.tjInitCompress();
            int bufSize = (int)this.lib.tjBufSize(img.getWidth(), img.getHeight(), sampling);
            bufPtr = this.lib.tjAlloc(bufSize);
            NativeLongByReference lenPtr = new NativeLongByReference((long)bufSize);
            ByteBuffer inBuf = ByteBuffer.wrap(((DataBufferByte)img.getDataBuffer()).getData()).order(this.runtime.byteOrder());
            int rv = this.lib.tjCompress2(codec, inBuf, img.getWidth(), 0, img.getHeight(), pixelFmt, new PointerByReference(bufPtr), lenPtr, sampling, quality, 0);
            if (rv != 0) {
                LOG.error("Could not compress image (dimensions: {}x{}, format: {}, sampling: {}, quality: {}", new Object[]{img.getWidth(), img.getHeight(), pixelFmt, sampling, quality});
                throw new TurboJpegException(this.lib.tjGetErrorStr());
            }
            ByteBuffer outBuf = ByteBuffer.allocate(((NativeLong)lenPtr.getValue()).intValue()).order(this.runtime.byteOrder());
            bufPtr.get(0L, outBuf.array(), 0, ((NativeLong)lenPtr.getValue()).intValue());
            ((Buffer)outBuf).rewind();
            byteBuffer = outBuf;
        }
        catch (Throwable throwable) {
            if (codec != null && codec.address() != 0L) {
                this.lib.tjDestroy(codec);
            }
            if (bufPtr != null && bufPtr.address() != 0L) {
                this.lib.tjFree(bufPtr);
            }
            throw throwable;
        }
        if (codec != null && codec.address() != 0L) {
            this.lib.tjDestroy(codec);
        }
        if (bufPtr != null && bufPtr.address() != 0L) {
            this.lib.tjFree(bufPtr);
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer transform(byte[] jpegData, Info info, Rectangle region, int rotation) throws TurboJpegException {
        ByteBuffer byteBuffer;
        Pointer codec = null;
        Pointer bufPtr = null;
        try {
            boolean flipCoords;
            codec = this.lib.tjInitTransform();
            tjtransform transform = new tjtransform(this.runtime);
            int width = info.getWidth();
            int height = info.getHeight();
            boolean bl = flipCoords = rotation == 90 || rotation == 270;
            if (region != null) {
                Dimension mcuSize = info.getMCUSize();
                if (region.width % mcuSize.width != 0 || region.height % mcuSize.height != 0) {
                    throw new IllegalArgumentException(String.format("Invalid cropping region, width must be divisible by %d, height by %d", mcuSize.width, mcuSize.height));
                }
                width = region.width;
                height = region.height;
                transform.options.set(TJXOPT.TJXOPT_CROP | TJXOPT.TJXOPT_TRIM);
                transform.r.x.set(region.x);
                transform.r.y.set(region.y);
                if (region.x + region.width >= (flipCoords ? info.getHeight() : info.getWidth())) {
                    transform.r.w.set(0);
                } else {
                    transform.r.w.set(region.width);
                }
                if (region.y + region.height >= (flipCoords ? info.getWidth() : info.getHeight())) {
                    transform.r.h.set(0);
                } else {
                    transform.r.h.set(region.height);
                }
            }
            if (rotation != 0) {
                TJXOP op;
                if (flipCoords) {
                    int w = width;
                    int h = height;
                    height = w;
                    width = h;
                }
                switch (rotation) {
                    case 90: {
                        op = TJXOP.TJXOP_ROT90;
                        break;
                    }
                    case 180: {
                        op = TJXOP.TJXOP_ROT180;
                        break;
                    }
                    case 270: {
                        op = TJXOP.TJXOP_ROT270;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid rotation, must be 90, 180 or 270");
                    }
                }
                transform.op.set(op.intValue());
            }
            int bufWidth = width;
            if (width == 0 && region != null) {
                bufWidth = info.getWidth() - region.x;
            }
            int bufHeight = height;
            if (height == 0 && region != null) {
                bufHeight = info.getHeight() - region.y;
            }
            int bufSize = (int)this.lib.tjBufSize(bufWidth, bufHeight, TJSAMP.TJSAMP_444);
            bufPtr = this.lib.tjAlloc(bufSize);
            NativeLongByReference lenRef = new NativeLongByReference((long)bufSize);
            ByteBuffer inBuf = ByteBuffer.wrap(jpegData).order(this.runtime.byteOrder());
            int rv = this.lib.tjTransform(codec, inBuf, jpegData.length, 1, new PointerByReference(bufPtr), lenRef, transform, 0);
            if (rv != 0) {
                LOG.error("Could not compress image (crop: {},{},{},{}, rotate: {})", new Object[]{transform.r.x, transform.r.y, transform.r.w, transform.r.h, rotation});
                throw new TurboJpegException(this.lib.tjGetErrorStr());
            }
            ByteBuffer outBuf = ByteBuffer.allocate(((NativeLong)lenRef.getValue()).intValue()).order(this.runtime.byteOrder());
            bufPtr.get(0L, outBuf.array(), 0, ((NativeLong)lenRef.getValue()).intValue());
            ((Buffer)outBuf).rewind();
            byteBuffer = outBuf;
        }
        catch (Throwable throwable) {
            if (codec != null && codec.address() != 0L) {
                this.lib.tjDestroy(codec);
            }
            if (bufPtr != null && bufPtr.address() != 0L) {
                this.lib.tjFree(bufPtr);
            }
            throw throwable;
        }
        if (codec != null && codec.address() != 0L) {
            this.lib.tjDestroy(codec);
        }
        if (bufPtr != null && bufPtr.address() != 0L) {
            this.lib.tjFree(bufPtr);
        }
        return byteBuffer;
    }
}

