/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.turbojpeg;

import de.digitalcollections.turbojpeg.lib.structs.tjscalingfactor;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class Info {
    private int width;
    private int height;
    private int subsampling;
    List<Dimension> availableSizes;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSubsampling() {
        return this.subsampling;
    }

    public List<Dimension> getAvailableSizes() {
        return this.availableSizes;
    }

    private static int getScaled(int dim, int num, int denom) {
        return (dim * num + denom - 1) / denom;
    }

    public Info(int width, int height, int subsampling, tjscalingfactor[] factors) {
        this.width = width;
        this.height = height;
        this.subsampling = subsampling;
        this.availableSizes = Arrays.stream(factors).filter(f -> f.denom.get() > 0).sorted(Comparator.comparing(f -> -Info.getScaled(width, f.num.get(), f.denom.get()))).map(f -> new Dimension(Info.getScaled(width, f.num.get(), f.denom.get()), Info.getScaled(height, f.num.get(), f.denom.get()))).filter(d -> d.width <= width && d.height <= height && d.width > 0 && d.height > 0).distinct().collect(Collectors.toList());
    }

    public Dimension getMCUSize() {
        switch (this.subsampling) {
            case 1: {
                return new Dimension(16, 8);
            }
            case 2: {
                return new Dimension(16, 16);
            }
            case 4: {
                return new Dimension(8, 16);
            }
        }
        return new Dimension(8, 8);
    }
}

