/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.turbojpeg.imageio;

import de.digitalcollections.turbojpeg.Info;
import de.digitalcollections.turbojpeg.TurboJpeg;
import de.digitalcollections.turbojpeg.TurboJpegException;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReadParam;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurboJpegImageReader
extends ImageReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurboJpegImageReader.class);
    private final TurboJpeg lib;
    private ByteBuffer jpegData;
    private Info info;

    protected TurboJpegImageReader(ImageReaderSpi originatingProvider, TurboJpeg lib) {
        super(originatingProvider);
        this.lib = lib;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            return;
        }
        if (input instanceof ImageInputStream) {
            try {
                this.jpegData = this.bufferFromStream((ImageInputStream)input);
                this.info = this.lib.getInfo(this.jpegData.array());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read input.");
            }
            catch (TurboJpegException e) {
                throw new IllegalArgumentException("Failed to read JPEG info.");
            }
        } else {
            throw new IllegalArgumentException("Bad input.");
        }
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex >= this.info.getAvailableSizes().size()) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    private ByteBuffer bufferFromStream(ImageInputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while (0 < (n = stream.read(buf))) {
            bos.write(buf, 0, n);
        }
        return ByteBuffer.wrap(bos.toByteArray());
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new TurboJpegImageReadParam();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.info.getAvailableSizes().size();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.info.getAvailableSizes().get((int)imageIndex).width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return this.info.getAvailableSizes().get((int)imageIndex).height;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return Stream.of(5, 6, 7, 10).map(ImageTypeSpecifier::createFromBufferedImageType).iterator();
    }

    private Rectangle adjustRegion(Dimension mcuSize, Rectangle region, int rotation) throws IOException {
        int x;
        if (region == null) {
            return null;
        }
        boolean modified = false;
        int originalWidth = this.getWidth(0);
        int originalHeight = this.getHeight(0);
        if (rotation == 90) {
            x = region.x;
            region.x = originalHeight - region.height - region.y;
            region.y = x;
        }
        if (rotation == 180) {
            region.x = originalWidth - region.width - region.x;
            region.y = originalHeight - region.height - region.y;
        }
        if (rotation == 270) {
            x = region.x;
            region.x = region.y;
            region.y = originalWidth - region.width - x;
        }
        if (rotation == 90 || rotation == 270) {
            int w = region.width;
            region.width = region.height;
            region.height = w;
        }
        Rectangle extraCrop = new Rectangle(0, 0, region.width == 0 ? originalWidth - region.x : region.width, region.height == 0 ? originalHeight - region.y : region.height);
        if (region.x % mcuSize.width != 0) {
            extraCrop.x = region.x % mcuSize.width;
            region.x -= extraCrop.x;
            if (region.width > 0) {
                region.width += extraCrop.x;
            }
            modified = true;
        }
        if (region.y % mcuSize.height != 0) {
            extraCrop.y = region.y % mcuSize.height;
            region.y -= extraCrop.y;
            if (region.height > 0) {
                region.height += extraCrop.y;
            }
            modified = true;
        }
        if (region.width % mcuSize.width != 0) {
            region.width = (int)((double)mcuSize.width * Math.ceil(region.getWidth() / (double)mcuSize.width));
            modified = true;
        }
        if (region.height % mcuSize.height != 0) {
            region.height = (int)((double)mcuSize.height * Math.ceil(region.getHeight() / (double)mcuSize.height));
            modified = true;
        }
        if (modified) {
            return extraCrop;
        }
        return null;
    }

    private void adjustExtraCrop(int imageIndex, Info croppedInfo, Rectangle rectangle) {
        double factor = croppedInfo.getAvailableSizes().get(imageIndex).getWidth() / croppedInfo.getAvailableSizes().get(0).getWidth();
        if (factor < 1.0) {
            rectangle.x = (int)Math.round(factor * (double)rectangle.x);
            rectangle.y = (int)Math.round(factor * (double)rectangle.y);
            rectangle.width = (int)Math.round(factor * (double)rectangle.width);
            rectangle.height = (int)Math.round(factor * (double)rectangle.height);
        }
        int maxWidth = croppedInfo.getAvailableSizes().get((int)imageIndex).width;
        int maxHeight = croppedInfo.getAvailableSizes().get((int)imageIndex).height;
        if (rectangle.x + rectangle.width > maxWidth) {
            rectangle.width = maxWidth - rectangle.x;
        }
        if (rectangle.y + rectangle.height > maxHeight) {
            rectangle.height = maxHeight - rectangle.y;
        }
    }

    private void scaleRegion(int targetIndex, Rectangle sourceRegion) throws IOException {
        if (targetIndex == 0) {
            return;
        }
        int nativeWidth = this.getWidth(0);
        int nativeHeight = this.getHeight(0);
        double scaleFactor = (double)nativeWidth / (double)this.getWidth(targetIndex);
        sourceRegion.x = (int)Math.ceil(scaleFactor * (double)sourceRegion.x);
        sourceRegion.y = (int)Math.ceil(scaleFactor * (double)sourceRegion.y);
        sourceRegion.width = Math.min((int)Math.ceil(scaleFactor * (double)sourceRegion.width), nativeWidth - sourceRegion.x);
        sourceRegion.height = Math.min((int)Math.ceil(scaleFactor * (double)sourceRegion.height), nativeHeight - sourceRegion.y);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        ByteBuffer data = this.jpegData;
        try {
            int rotation = 0;
            Rectangle region = null;
            Rectangle extraCrop = null;
            if (param instanceof TurboJpegImageReadParam) {
                rotation = ((TurboJpegImageReadParam)param).getRotationDegree();
            }
            if (param != null && param.getSourceRegion() != null) {
                region = param.getSourceRegion();
                this.scaleRegion(imageIndex, region);
                if (!this.isRegionFullImage(imageIndex, region)) {
                    extraCrop = this.adjustRegion(this.info.getMCUSize(), region, rotation);
                } else {
                    region = null;
                }
            }
            if (region != null || rotation != 0) {
                data = this.lib.transform(data.array(), this.info, region, rotation);
            }
            Info transformedInfo = this.lib.getInfo(data.array());
            BufferedImage img = this.lib.decode(data.array(), transformedInfo, transformedInfo.getAvailableSizes().get(imageIndex));
            if (extraCrop != null) {
                this.adjustExtraCrop(imageIndex, transformedInfo, extraCrop);
                img = img.getSubimage(extraCrop.x, extraCrop.y, extraCrop.width, extraCrop.height);
            }
            return img;
        }
        catch (TurboJpegException e) {
            throw new IOException(e);
        }
    }

    private boolean isRegionFullImage(int imageIndex, Rectangle region) throws IOException {
        int nativeWidth = this.getWidth(imageIndex);
        int nativeHeight = this.getHeight(imageIndex);
        return !(region.x != 0 || region.y != 0 || region.width != 0 && region.width != nativeWidth || region.height != 0 && region.height != nativeHeight);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }
}

