/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.turbojpeg.imageio;

import com.google.common.collect.ImmutableSet;
import de.digitalcollections.turbojpeg.TurboJpeg;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.stream.Stream;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurboJpegImageWriterSpi
extends ImageWriterSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurboJpegImageWriterSpi.class);
    private static final String vendorName = "M\u00fcnchener Digitalisierungszentrum/Digitale Bibliothek, Bayerische Staatsbibliothek";
    private static final String version = "0.1.0";
    private static final String writerClassName = "de.digitalcollections.openjpeg.turbojpeg.TurboJpegImageWriter";
    private static final String[] names = new String[]{"JPEG", "jpeg", "JPG", "jpg"};
    private static final String[] suffixes = new String[]{"jpg", "jpeg"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String[] readerSpiNames = new String[]{"de.digitalcollections.turbojpeg.imageio.TurboJpegImageReaderSpi"};
    private static final Class[] outputTypes = new Class[]{ImageOutputStream.class};
    private TurboJpeg lib;

    public TurboJpegImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, outputTypes, readerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    private void loadLibrary() throws IOException {
        if (this.lib == null) {
            try {
                this.lib = new TurboJpeg();
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.error("Could not load libturbojpeg", (Throwable)e);
                throw new IOException(e);
            }
        }
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        Stream.of("com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageWriterSpi", "com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi").forEach(clsName -> {
            try {
                ImageWriterSpi defaultProvider = (ImageWriterSpi)registry.getServiceProviderByClass(Class.forName(clsName));
                registry.setOrdering(category, this, defaultProvider);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return (type.getNumBands() == 3 || type.getNumBands() == 1) && ImmutableSet.of((Object)5, (Object)6, (Object)10).contains((Object)type.getBufferedImageType());
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        this.loadLibrary();
        return new TurboJpegImageWriter(this, this.lib);
    }

    @Override
    public String getDescription(Locale locale) {
        return "JPEG writer plugin based on libjpeg-turbo/turbojpeg.";
    }
}

