/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg;

import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_read_fn;
import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_skip_fn;
import de.digitalcollections.openjpeg.lib.libopenjp2;
import jnr.ffi.Pointer;

public abstract class InStreamWrapper {
    private Pointer stream;
    private final libopenjp2 lib;
    private final opj_stream_read_fn readCallback;
    private final opj_stream_skip_fn skipCallback;

    protected InStreamWrapper(libopenjp2 lib) {
        this.lib = lib;
        this.stream = lib.opj_stream_create(0x100000L, true);
        this.skipCallback = this::skip;
        this.readCallback = this::read;
        lib.opj_stream_set_read_function(this.stream, this.readCallback);
        lib.opj_stream_set_skip_function(this.stream, this.skipCallback);
        lib.opj_stream_set_user_data_length(this.stream, (long)Math.pow(2.0, 32.0));
    }

    public Pointer getNativeStream() {
        return this.stream;
    }

    protected abstract long read(Pointer var1, long var2, Pointer var4);

    protected abstract long skip(long var1, Pointer var3);

    public void close() {
        this.lib.opj_stream_destroy(this.stream);
        this.stream = null;
    }
}

