/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg.imageio;

import de.digitalcollections.openjpeg.OpenJpeg;
import de.digitalcollections.openjpeg.lib.enums.PROG_ORDER;
import de.digitalcollections.openjpeg.lib.structs.opj_cparameters;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.imageio.ImageWriteParam;

public class OpenJp2ImageWriteParam
extends ImageWriteParam {
    public static String COMPRESS_TYPE_LOSSY = "lossy";
    public static String COMPRESS_TYPE_LOSSLESS = "lossless";
    boolean compressLossy = false;
    boolean writeSOPMarkers = false;
    boolean writeEPHMarkers = false;
    int numResolutions = 6;
    ProgressionOrder progOrder = ProgressionOrder.LRCP;

    protected opj_cparameters toNativeParams(OpenJpeg lib) {
        opj_cparameters params = new opj_cparameters(lib.runtime);
        lib.lib.opj_set_default_encoder_parameters(params);
        if (this.getTilingMode() == 2) {
            params.tile_size_on.set(true);
            params.cp_tx0.set(this.getTileGridXOffset());
            params.cp_ty0.set(this.getTileGridYOffset());
            params.cp_tdx.set(this.getTileWidth());
            params.cp_tdy.set(this.getTileHeight());
        }
        params.numresolution.set(this.numResolutions);
        params.prog_order.set((Enum)this.progOrder.toNative());
        if (this.writeSOPMarkers) {
            params.csty.set(params.csty.intValue() | 2);
        }
        if (this.writeEPHMarkers) {
            params.csty.set(params.csty.intValue() | 4);
        }
        params.tcp_mct.set((Number)1);
        params.tcp_numlayers.set(1);
        params.cp_disto_alloc.set(1);
        if (this.compressLossy) {
            params.irreversible.set(1);
        }
        if (this.getCompressionMode() == 2) {
            params.tcp_rates[0].set(Math.max(100.0f - this.getCompressionQuality() * 100.0f, 0.0f));
        } else {
            params.tcp_rates[0].set(0.0f);
        }
        params.tcp_mct.set((Number)1);
        return params;
    }

    @Override
    public boolean canWriteTiles() {
        return true;
    }

    @Override
    public boolean canOffsetTiles() {
        return true;
    }

    @Override
    public boolean canWriteProgressive() {
        return true;
    }

    @Override
    public boolean canWriteCompressed() {
        return true;
    }

    @Override
    public String[] getCompressionTypes() {
        return new String[]{"lossless", "lossy"};
    }

    @Override
    public void setCompressionType(String compressionType) {
        if (Stream.of(COMPRESS_TYPE_LOSSLESS, COMPRESS_TYPE_LOSSY).noneMatch(compressionType::equals)) {
            throw new IllegalArgumentException("Unknown compression type");
        }
        this.compressLossy = compressionType.equals(COMPRESS_TYPE_LOSSY);
    }

    @Override
    public String getCompressionType() {
        if (this.compressLossy) {
            return COMPRESS_TYPE_LOSSY;
        }
        return COMPRESS_TYPE_LOSSLESS;
    }

    @Override
    public void unsetCompression() {
        super.unsetCompression();
        this.compressLossy = false;
    }

    @Override
    public boolean isCompressionLossless() {
        super.isCompressionLossless();
        return !this.compressLossy;
    }

    public boolean shouldWriteSOPMarkers() {
        return this.writeSOPMarkers;
    }

    public void setWriteSOPMarkers(boolean writeSOPMarkers) {
        this.writeSOPMarkers = writeSOPMarkers;
    }

    public boolean shouldWriteEPHMarkers() {
        return this.writeEPHMarkers;
    }

    public void setWriteEPHMarkers(boolean writeEPHMarkers) {
        this.writeEPHMarkers = writeEPHMarkers;
    }

    @Override
    public void setCompressionQuality(float quality) {
        super.setCompressionQuality(quality);
        this.compressLossy = true;
    }

    public int getNumResolutions() {
        return this.numResolutions;
    }

    public void setNumResolutions(int numResolutions) {
        this.numResolutions = numResolutions;
    }

    public ProgressionOrder getProgressionOrder() {
        return this.progOrder;
    }

    public void setProgressionOrder(ProgressionOrder progOrder) {
        this.progOrder = progOrder;
    }

    public static enum ProgressionOrder {
        LRCP(0),
        RLCP(1),
        RPCL(2),
        PCRL(3),
        CPRL(4);

        private final int val;

        private ProgressionOrder(int val) {
            this.val = val;
        }

        PROG_ORDER toNative() {
            return Arrays.stream(PROG_ORDER.values()).filter(v -> v.value == this.val).findFirst().orElseThrow(RuntimeException::new);
        }
    }
}

