/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg;

import de.digitalcollections.openjpeg.CMYKColorSpace;
import de.digitalcollections.openjpeg.InStreamWrapper;
import de.digitalcollections.openjpeg.Info;
import de.digitalcollections.openjpeg.OutStreamWrapper;
import de.digitalcollections.openjpeg.lib.callbacks.opj_msg_callback;
import de.digitalcollections.openjpeg.lib.enums.CODEC_FORMAT;
import de.digitalcollections.openjpeg.lib.enums.COLOR_SPACE;
import de.digitalcollections.openjpeg.lib.libopenjp2;
import de.digitalcollections.openjpeg.lib.structs.opj_codestream_info_v2;
import de.digitalcollections.openjpeg.lib.structs.opj_cparameters;
import de.digitalcollections.openjpeg.lib.structs.opj_dparameters;
import de.digitalcollections.openjpeg.lib.structs.opj_image;
import de.digitalcollections.openjpeg.lib.structs.opj_image_comp;
import de.digitalcollections.openjpeg.lib.structs.opj_image_comptparm;
import de.digitalcollections.openjpeg.lib.structs.opj_tccp_info;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.byref.PointerByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenJpeg {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenJpeg.class);
    private static final opj_msg_callback debugLogFn = (msg, data) -> LOGGER.debug(msg.trim());
    private static final opj_msg_callback warnLogFn = (msg, data) -> LOGGER.warn(msg.trim());
    private static final opj_msg_callback errorLogFn = (msg, data) -> LOGGER.error(msg.trim());
    public static final ColorModel COLOR_MODEL_CMYK = new ComponentColorModel(new CMYKColorSpace(), false, false, 3, 0);
    public static final ColorModel COLOR_MODEL_CMYK_ALPHA = new ComponentColorModel(new CMYKColorSpace(), true, false, 3, 0);
    public libopenjp2 lib = (libopenjp2)LibraryLoader.create(libopenjp2.class).load("openjp2");
    public Runtime runtime;

    public OpenJpeg() {
        if (this.lib == null) {
            throw new UnsatisfiedLinkError("Could not load libopenjp2, make sure it is installed!");
        }
        if (!this.lib.opj_version().startsWith("2.")) {
            throw new UnsatisfiedLinkError(String.format("OpenJPEG version must be at least 2.0.0 (found: %s)", this.lib.opj_version()));
        }
        this.runtime = Runtime.getRuntime((Object)this.lib);
    }

    private void setupLogger(Pointer codec) {
        if (LOGGER.isDebugEnabled() && !this.lib.opj_set_info_handler(codec, debugLogFn)) {
            throw new RuntimeException("Could not set info logging handler");
        }
        if (LOGGER.isWarnEnabled() && !this.lib.opj_set_warning_handler(codec, warnLogFn)) {
            throw new RuntimeException("Could not set warning logging handler");
        }
        if (LOGGER.isErrorEnabled() && !this.lib.opj_set_error_handler(codec, errorLogFn)) {
            throw new RuntimeException("Could not set error logging handler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo(Path filePath) throws IOException {
        Pointer ptr = this.createOpjFileStream(filePath);
        try {
            Info info = this.getInfo(ptr);
            return info;
        }
        finally {
            this.lib.opj_stream_destroy(ptr);
        }
    }

    public Info getInfo(InStreamWrapper wrapper) throws IOException {
        try {
            Info info = this.getInfo(wrapper.getNativeStream());
            return info;
        }
        finally {
            wrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info getInfo(Pointer stream) throws IOException {
        Pointer codec = null;
        opj_image img = null;
        try {
            codec = this.getCodec(0);
            img = this.getImage(stream, codec);
            Info info = this.getInfo(codec, img);
            return info;
        }
        finally {
            if (codec != null) {
                this.lib.opj_destroy_codec(codec);
            }
            if (img != null) {
                img.free(this.lib);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info getInfo(Pointer codecPointer, opj_image img) {
        opj_codestream_info_v2 csInfo = null;
        try {
            csInfo = this.lib.opj_get_cstr_info(codecPointer);
            Info info = new Info();
            info.setWidth(img.x1.intValue());
            info.setHeight(img.y1.intValue());
            info.setNumComponents(csInfo.nbcomps.intValue());
            info.setNumTilesX(csInfo.tw.intValue());
            info.setNumTilesY(csInfo.th.intValue());
            info.setTileWidth(csInfo.tdx.intValue());
            info.setTileHeight(csInfo.tdy.intValue());
            info.setTileOriginX(csInfo.tx0.intValue());
            info.setTileOriginY(csInfo.ty0.intValue());
            info.setNumResolutions(((opj_tccp_info)csInfo.m_default_tile_info.tccp_info.get()).numresolutions.intValue());
            info.setBitsPerPixel(((opj_image_comp)img.comps.get()).bpp.intValue());
            info.setColorSpace((COLOR_SPACE)img.color_space.get());
            Info info2 = info;
            return info2;
        }
        finally {
            if (csInfo != null) {
                csInfo.free(this.lib);
            }
        }
    }

    private Pointer getCodec(int reduceFactor) throws IOException {
        Pointer codec = this.lib.opj_create_decompress(CODEC_FORMAT.OPJ_CODEC_JP2);
        this.setupLogger(codec);
        opj_dparameters params = new opj_dparameters(Runtime.getRuntime((Object)this.lib));
        this.lib.opj_set_default_decoder_parameters(params);
        params.cp_reduce.set((long)reduceFactor);
        if (!this.lib.opj_setup_decoder(codec, params)) {
            throw new IOException("Error setting up decoder!");
        }
        return codec;
    }

    private opj_image getImage(Pointer stream, Pointer codec) throws IOException {
        opj_image img = new opj_image(Runtime.getRuntime((Object)this.lib));
        PointerByReference imgPtr = new PointerByReference();
        if (!this.lib.opj_read_header(stream, codec, imgPtr)) {
            throw new IOException("Error while reading header.");
        }
        img.useMemory((Pointer)imgPtr.getValue());
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage decode(InStreamWrapper wrapper, Rectangle area, int reduceFactor) throws IOException {
        try {
            BufferedImage bufferedImage = this.decode(wrapper.getNativeStream(), area, reduceFactor);
            return bufferedImage;
        }
        finally {
            wrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage decode(Path filePath, Rectangle area, int reduceFactor) throws IOException {
        Pointer ptr = this.createOpjFileStream(filePath);
        try {
            BufferedImage bufferedImage = this.decode(ptr, area, reduceFactor);
            return bufferedImage;
        }
        finally {
            this.lib.opj_stream_destroy(ptr);
        }
    }

    private Pointer createOpjFileStream(Path filePath) throws IOException {
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("File not found at %s", filePath));
        }
        if (!Files.isReadable(filePath)) {
            throw new IOException(String.format("File not readable at %s", filePath));
        }
        return this.lib.opj_stream_create_default_file_stream(filePath.toAbsolutePath().toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage decode(Pointer stream, Rectangle area, int reduceFactor) throws IOException {
        Pointer codec = null;
        opj_image img = null;
        try {
            BufferedImage bufImg;
            codec = this.getCodec(reduceFactor);
            img = this.getImage(stream, codec);
            if (area == null) {
                if (!this.lib.opj_set_decode_area(codec, Struct.getMemory((Struct)img), img.x0.intValue(), img.y0.intValue(), img.x1.intValue(), img.y1.intValue())) {
                    throw new IOException("Could not set decoding area!");
                }
            } else {
                this.lib.opj_set_decode_area(codec, Struct.getMemory((Struct)img), area.x, area.y, area.x + area.width, area.y + area.height);
            }
            if (!this.lib.opj_decode(codec, stream, Struct.getMemory((Struct)img))) {
                throw new IOException("Could not decode image!");
            }
            int numcomps = img.numcomps.intValue();
            opj_image_comp[] comps = (opj_image_comp[])img.comps.get(numcomps);
            int targetWidth = comps[0].w.intValue();
            int targetHeight = comps[0].h.intValue();
            COLOR_SPACE colorSpace = (COLOR_SPACE)img.color_space.get();
            if (colorSpace == COLOR_SPACE.OPJ_CLRSPC_SYCC) {
                throw new IOException("Images with YUV color space are currently not supported.");
            }
            int colorDepthFactor = (int)Math.pow(2.0, comps[0].bpp.intValue()) / 256;
            colorDepthFactor = colorDepthFactor > 0 ? colorDepthFactor : 1;
            switch (numcomps) {
                case 3: {
                    bufImg = new BufferedImage(targetWidth, targetHeight, 5);
                    Pointer red = comps[0].data.get();
                    Pointer green = comps[1].data.get();
                    Pointer blue = comps[2].data.get();
                    byte[] bgrData = ((DataBufferByte)bufImg.getRaster().getDataBuffer()).getData();
                    for (int i = 0; i < targetWidth * targetHeight; ++i) {
                        bgrData[i * 3] = (byte)(blue.getInt((long)(i * 4)) / colorDepthFactor);
                        bgrData[i * 3 + 1] = (byte)(green.getInt((long)(i * 4)) / colorDepthFactor);
                        bgrData[i * 3 + 2] = (byte)(red.getInt((long)(i * 4)) / colorDepthFactor);
                    }
                    break;
                }
                case 1: {
                    Pointer ptr = comps[0].data.get();
                    int bitPerPixel = comps[0].bpp.intValue();
                    if (bitPerPixel == 1) {
                        bufImg = new BufferedImage(targetWidth, targetHeight, 12);
                        byte[] data = ((DataBufferByte)bufImg.getRaster().getDataBuffer()).getData();
                        int stride = (int)Math.ceil((double)targetWidth / 8.0);
                        for (int scanline = 0; scanline < targetHeight; ++scanline) {
                            for (int linePos = 0; linePos < stride; ++linePos) {
                                int srcIdx = scanline * targetWidth + linePos * 8;
                                int pixToPack = linePos * 8 > targetWidth ? 8 - (linePos * 8 - targetWidth) : 8;
                                for (int packedIdx = 0; packedIdx < pixToPack; ++packedIdx) {
                                    byte px = (byte)ptr.getInt((long)((srcIdx + packedIdx) * 4));
                                    int n = scanline * stride + linePos;
                                    data[n] = (byte)(data[n] | px << 7 - packedIdx);
                                }
                            }
                        }
                        break;
                    }
                    if (bitPerPixel <= 8) {
                        bufImg = new BufferedImage(targetWidth, targetHeight, 10);
                        byte[] data = ((DataBufferByte)bufImg.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < targetWidth * targetHeight; ++i) {
                            data[i] = (byte)(ptr.getInt((long)(i * 4)) / colorDepthFactor);
                        }
                        break;
                    }
                    if (bitPerPixel <= 16) {
                        bufImg = new BufferedImage(targetWidth, targetHeight, 11);
                        short[] data = ((DataBufferUShort)bufImg.getRaster().getDataBuffer()).getData();
                        for (int i = 0; i < targetWidth * targetHeight; ++i) {
                            data[i] = (short)ptr.getInt((long)(i * 4));
                        }
                        break;
                    }
                    throw new IOException("unsupported bit depth (>16bit)");
                }
                case 2: {
                    bufImg = new BufferedImage(targetWidth, targetHeight, 6);
                    Pointer gray = comps[0].data.get();
                    Pointer alpha = comps[1].data.get();
                    byte[] bgrData = ((DataBufferByte)bufImg.getRaster().getDataBuffer()).getData();
                    int j = 0;
                    for (int i = 0; i < targetWidth * targetHeight; ++i) {
                        bgrData[j++] = (byte)(alpha.getInt((long)(i * 4)) / colorDepthFactor);
                        byte colValue = (byte)(gray.getInt((long)(i * 4)) / colorDepthFactor);
                        bgrData[j++] = colValue;
                        bgrData[j++] = colValue;
                        bgrData[j++] = colValue;
                    }
                    break;
                }
                case 4: {
                    if (colorSpace == COLOR_SPACE.OPJ_CLRSPC_CMYK) {
                        bufImg = this.decodeCMYK(targetWidth, targetHeight, numcomps, colorDepthFactor, comps);
                        break;
                    }
                    bufImg = new BufferedImage(targetWidth, targetHeight, 6);
                    Pointer red = comps[0].data.get();
                    Pointer green = comps[1].data.get();
                    Pointer blue = comps[2].data.get();
                    Pointer alpha = comps[3].data.get();
                    byte[] bgrData = ((DataBufferByte)bufImg.getRaster().getDataBuffer()).getData();
                    int j = 0;
                    for (int i = 0; i < targetWidth * targetHeight; ++i) {
                        bgrData[j++] = (byte)(alpha.getInt((long)(i * 4)) / colorDepthFactor);
                        bgrData[j++] = (byte)(blue.getInt((long)(i * 4)) / colorDepthFactor);
                        bgrData[j++] = (byte)(green.getInt((long)(i * 4)) / colorDepthFactor);
                        bgrData[j++] = (byte)(red.getInt((long)(i * 4)) / colorDepthFactor);
                    }
                    break;
                }
                case 5: {
                    bufImg = this.decodeCMYK(targetWidth, targetHeight, numcomps, colorDepthFactor, comps);
                    break;
                }
                default: {
                    throw new IOException(String.format("Unsupported number of components: %d", numcomps));
                }
            }
            BufferedImage bufferedImage = bufImg;
            return bufferedImage;
        }
        finally {
            if (img != null) {
                img.free(this.lib);
            }
            if (codec != null) {
                this.lib.opj_destroy_codec(codec);
            }
        }
    }

    private BufferedImage decodeCMYK(int width, int height, int numcomps, int colorDepthFactor, opj_image_comp[] comps) {
        boolean hasAlpha = numcomps > 4;
        ColorModel colorModel = hasAlpha ? COLOR_MODEL_CMYK_ALPHA : COLOR_MODEL_CMYK;
        BufferedImage bufImg = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(width, height), false, null);
        Pointer[] data = new Pointer[numcomps];
        for (int i = 0; i < data.length; ++i) {
            data[i] = comps[i].data.get();
        }
        byte[] bgrData = ((DataBufferByte)bufImg.getRaster().getDataBuffer()).getData();
        int j = 0;
        for (int i = 0; i < width * height; ++i) {
            for (Pointer datum : data) {
                bgrData[j++] = (byte)(datum.getInt((long)(i * 4)) / colorDepthFactor);
            }
        }
        return bufImg;
    }

    private static <T extends Struct> T[] arrayOfDirectlyAllocated(Runtime runtime, Class<T> type, int length) {
        try {
            Struct[] array = (Struct[])Array.newInstance(type, length);
            Constructor<T> c = type.getConstructor(Runtime.class);
            for (int i = 0; i < length; ++i) {
                array[i] = (Struct)c.newInstance(runtime);
            }
            if (array.length > 0) {
                int align = Struct.alignment((Struct)array[0]);
                int structSize = Struct.size((Struct)array[0]) + align - 1 & ~(align - 1);
                Pointer memory = runtime.getMemoryManager().allocateDirect(Math.max(512, structSize * length));
                for (int i = 0; i < array.length; ++i) {
                    array[i].useMemory(memory.slice((long)(structSize * i), (long)structSize));
                }
            }
            return array;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private opj_image createImage(Raster img) {
        int numBands = img.getSampleModel().getNumBands();
        if (numBands != 3 && numBands != 1) {
            throw new IllegalArgumentException("Image must be RGB or Greyscale");
        }
        if (!(img.getSampleModel() instanceof PixelInterleavedSampleModel)) {
            throw new IllegalArgumentException("Image must be of the 3BYTE_BGR or BYTE_GRAY");
        }
        opj_image_comptparm[] params = (opj_image_comptparm[])OpenJpeg.arrayOfDirectlyAllocated((Runtime)this.runtime, opj_image_comptparm.class, (int)numBands);
        for (int i = 0; i < numBands; ++i) {
            params[i].prec.set(8L);
            params[i].bpp.set(8L);
            params[i].sgnd.set(0L);
            params[i].dx.set(1L);
            params[i].dy.set(1L);
            params[i].w.set((long)img.getWidth());
            params[i].h.set((long)img.getHeight());
        }
        COLOR_SPACE cspace = numBands == 3 ? COLOR_SPACE.OPJ_CLRSPC_SRGB : COLOR_SPACE.OPJ_CLRSPC_GRAY;
        opj_image outImg = new opj_image(this.runtime);
        Pointer imgPtr = this.lib.opj_image_create(params.length, Struct.getMemory((Struct)params[0]), cspace);
        outImg.useMemory(imgPtr);
        outImg.x0.set(0L);
        outImg.y0.set(0L);
        outImg.x1.set((long)img.getWidth());
        outImg.y1.set((long)img.getHeight());
        byte[] imgData = ((DataBufferByte)img.getDataBuffer()).getData();
        int numcomps = (int)outImg.numcomps.get();
        opj_image_comp[] comps = (opj_image_comp[])outImg.comps.get(numcomps);
        if (numcomps > 1) {
            Pointer red = comps[0].data.get();
            Pointer green = comps[1].data.get();
            Pointer blue = comps[2].data.get();
            int offset = 0;
            for (int y = 0; y < img.getHeight(); ++y) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    red.putByte((long)(offset * 4), imgData[offset * 3 + 2]);
                    green.putByte((long)(offset * 4), imgData[offset * 3 + 1]);
                    blue.putByte((long)(offset * 4), imgData[offset * 3]);
                    ++offset;
                }
            }
        } else {
            Pointer ptr = comps[0].data.get();
            for (int i = 0; i < img.getWidth() * img.getHeight(); ++i) {
                ptr.putByte((long)(i * 4), imgData[i]);
            }
        }
        return outImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(Raster img, OutStreamWrapper output, opj_cparameters params) throws IOException {
        opj_image image = null;
        Pointer codec = null;
        try {
            image = this.createImage(img);
            if (image.numcomps.get() == 1L) {
                params.tcp_mct.set((Number)0);
            }
            codec = this.lib.opj_create_compress(CODEC_FORMAT.OPJ_CODEC_JP2);
            this.setupLogger(codec);
            if (params == null) {
                params = new opj_cparameters(this.runtime);
                this.lib.opj_set_default_encoder_parameters(params);
            }
            if (!this.lib.opj_setup_encoder(codec, params, image)) {
                throw new IOException("Could not setup encoder!");
            }
            if (!this.lib.opj_start_compress(codec, image, output.getNativeStream())) {
                throw new IOException("Could not start encoding");
            }
            if (!this.lib.opj_encode(codec, output.getNativeStream())) {
                throw new IOException("Could not encode");
            }
            if (!this.lib.opj_end_compress(codec, output.getNativeStream())) {
                throw new IOException("Could not finish encoding.");
            }
            if (image != null) {
                image.free(this.lib);
            }
            if (codec != null) {
                this.lib.opj_destroy_codec(codec);
            }
            if (output != null) {
                output.close();
            }
        }
        catch (Throwable throwable) {
            if (image != null) {
                image.free(this.lib);
            }
            if (codec != null) {
                this.lib.opj_destroy_codec(codec);
            }
            if (output != null) {
                output.close();
            }
            throw throwable;
        }
    }
}

