/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg;

import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_seek_fn;
import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_skip_fn;
import de.digitalcollections.openjpeg.lib.callbacks.opj_stream_write_fn;
import de.digitalcollections.openjpeg.lib.libopenjp2;
import java.io.IOException;
import jnr.ffi.Pointer;

public abstract class OutStreamWrapper {
    private libopenjp2 lib;
    private Pointer stream;
    private opj_stream_write_fn writeCallback;
    private opj_stream_skip_fn skipCallback;
    private opj_stream_seek_fn seekCallback;

    protected OutStreamWrapper(libopenjp2 lib) {
        this.lib = lib;
        this.stream = lib.opj_stream_create(0x100000L, false);
        this.skipCallback = this::skip;
        this.seekCallback = this::seek;
        this.writeCallback = this::write;
        lib.opj_stream_set_write_function(this.stream, this.writeCallback);
        lib.opj_stream_set_skip_function(this.stream, this.skipCallback);
        lib.opj_stream_set_seek_function(this.stream, this.seekCallback);
        lib.opj_stream_set_user_data_length(this.stream, (long)Math.pow(2.0, 32.0));
    }

    public Pointer getNativeStream() {
        return this.stream;
    }

    protected abstract long write(Pointer var1, long var2, Pointer var4);

    protected abstract long skip(long var1, Pointer var3);

    protected abstract boolean seek(long var1, Pointer var3);

    public void close() throws IOException {
        this.lib.opj_stream_destroy(this.stream);
        this.stream = null;
    }
}

