/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.openjpeg;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Info {
    private int numComponents;
    private int numResolutions;
    private int tileWidth;
    private int tileHeight;
    private int tileOriginX;
    private int tileOriginY;
    private int numTilesX;
    private int numTilesY;
    private int width;
    private int height;

    void setNumComponents(int numComponents) {
        this.numComponents = numComponents;
    }

    void setNumResolutions(int numResolutions) {
        this.numResolutions = numResolutions;
    }

    void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    void setNumTilesX(int numTilesX) {
        this.numTilesX = numTilesX;
    }

    void setNumTilesY(int numTilesY) {
        this.numTilesY = numTilesY;
    }

    void setWidth(int width) {
        this.width = width;
    }

    void setHeight(int height) {
        this.height = height;
    }

    public void setTileOriginX(int tileOriginX) {
        this.tileOriginX = tileOriginX;
    }

    public void setTileOriginY(int tileOriginY) {
        this.tileOriginY = tileOriginY;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getNumResolutions() {
        return this.numResolutions;
    }

    public Dimension getNativeSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getTileSize() {
        return new Dimension(this.tileWidth, this.tileHeight);
    }

    public Point getTileOrigin() {
        return new Point(this.tileOriginX, this.tileOriginY);
    }

    public int getNumTilesX() {
        return this.numTilesX;
    }

    public int getNumTilesY() {
        return this.numTilesY;
    }

    public int getNumTiles() {
        return this.numTilesX + this.numTilesY;
    }

    public double[] getScaleFactors() {
        return IntStream.range(0, this.numResolutions).mapToDouble(n -> Math.pow(2.0, n)).toArray();
    }

    public List<Dimension> getAvailableImageSizes() {
        return Arrays.stream(this.getScaleFactors()).mapToObj(factor -> new Dimension((int)((double)this.width / factor), (int)((double)this.height / factor))).collect(Collectors.toList());
    }

    public List<Dimension> getAvailableTileSizes() {
        return Arrays.stream(this.getScaleFactors()).mapToObj(factor -> new Dimension((int)((double)this.tileWidth / factor), (int)((double)this.tileHeight / factor))).collect(Collectors.toList());
    }
}

