/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.digitalcollections.iiif.model.PropertyValue;

@JsonPropertyOrder(value={"label", "value"})
public class MetadataEntry {
    private PropertyValue label;
    private PropertyValue value;

    @JsonCreator
    public MetadataEntry(@JsonProperty(value="label") PropertyValue label, @JsonProperty(value="value") PropertyValue value) {
        this.label = label;
        this.value = value;
    }

    public MetadataEntry(String label, String value) {
        this.label = new PropertyValue(label, new String[0]);
        this.value = new PropertyValue(value, new String[0]);
    }

    public PropertyValue getLabel() {
        return this.label;
    }

    public PropertyValue getValue() {
        return this.value;
    }

    @JsonIgnore
    public String getLabelString() {
        return this.label.getFirstValue();
    }

    @JsonIgnore
    public String getValueString() {
        return this.value.getFirstValue();
    }

    public String toString() {
        return String.format("MetadataEntry(label=[%s],value=[%s]", this.getLabel().toString(), this.getValue().toString());
    }
}

