/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.ModelUtilities;
import de.digitalcollections.iiif.model.enums.ViewingDirection;
import de.digitalcollections.iiif.model.enums.ViewingHint;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Layer;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Range
extends Resource<Range> {
    public static final String TYPE = "sc:Range";
    private ViewingDirection viewingDirection;
    private URI startCanvas;
    private Layer contentLayer;
    List<Range> ranges;
    List<Canvas> canvases;
    List<Resource> members;

    @JsonCreator
    public Range(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    public Range(String identifier, String label) {
        this(identifier);
        this.addLabel(label, new String[0]);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public ViewingDirection getViewingDirection() {
        return this.viewingDirection;
    }

    public void setViewingDirection(ViewingDirection viewingDirection) {
        this.viewingDirection = viewingDirection;
    }

    @Override
    @JsonIgnore
    public Set<ViewingHint.Type> getSupportedViewingHintTypes() {
        return ImmutableSet.of((Object)((Object)ViewingHint.Type.INDIVIDUALS), (Object)((Object)ViewingHint.Type.PAGED), (Object)((Object)ViewingHint.Type.CONTINUOUS), (Object)((Object)ViewingHint.Type.TOP));
    }

    public URI getStartCanvas() {
        return this.startCanvas;
    }

    public void setStartCanvas(URI startCanvas) {
        this.startCanvas = startCanvas;
    }

    public Layer getContentLayer() {
        return this.contentLayer;
    }

    public void setContentLayer(Layer contentLayer) {
        this.contentLayer = contentLayer;
    }

    public void setContentLayer(String identifier) {
        this.setContentLayer(new Layer(identifier));
    }

    public List<Canvas> getCanvases() {
        return this.canvases;
    }

    private void checkIdOnly(Resource res) {
        ModelUtilities.Completeness completeness = ModelUtilities.getCompleteness(res, res.getClass());
        if (completeness != ModelUtilities.Completeness.ID_AND_TYPE && completeness != ModelUtilities.Completeness.ID_ONLY) {
            throw new IllegalArgumentException("Member resource must only have an identifier and no other field. Use add<Resource>(URI first, URI... rest) for convenience.");
        }
    }

    public void setCanvases(List<Canvas> canvases) {
        canvases.forEach(this::checkIdOnly);
        this.canvases = canvases;
    }

    public Range addCanvas(Canvas first, Canvas ... rest) {
        if (this.canvases == null) {
            this.canvases = new ArrayList<Canvas>();
        }
        this.checkIdOnly(first);
        Arrays.stream(rest).forEach(this::checkIdOnly);
        this.canvases.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public Range addCanvas(String idOfFirst, String ... idsOfRest) {
        return this.addCanvas(new Canvas(idOfFirst), (Canvas[])Arrays.stream(idsOfRest).map(Canvas::new).toArray(Canvas[]::new));
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<Range> ranges) {
        ranges.forEach(this::checkIdOnly);
        this.ranges = ranges;
    }

    public Range addRange(Range first, Range ... rest) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<Range>();
        }
        this.checkIdOnly(first);
        Arrays.stream(rest).forEach(this::checkIdOnly);
        this.ranges.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public Range addRange(String first, String ... rest) {
        return this.addRange(new Range(first), (Range[])Arrays.stream(rest).map(Range::new).toArray(Range[]::new));
    }

    public List<Resource> getMembers() {
        return this.members;
    }

    private void checkMember(Resource res) {
        if (!(res instanceof Range) && !(res instanceof Canvas)) {
            throw new IllegalArgumentException("Member resources must be either of type Range or Canvas");
        }
        if (res.getIdentifier() == null || res.getLabel() == null || res.getLabel().getValues().isEmpty()) {
            throw new IllegalArgumentException("Member resources must have identifier, type and label set.");
        }
    }

    public void setMembers(List<Resource> members) {
        members.forEach(this::checkMember);
        this.members = members;
    }

    public Range addMember(Resource first, Resource ... rest) throws IllegalArgumentException {
        if (this.members == null) {
            this.members = new ArrayList<Resource>();
        }
        List membersToAdd = Lists.asList((Object)first, (Object[])rest);
        membersToAdd.forEach(this::checkMember);
        this.members.addAll(membersToAdd);
        return this;
    }
}

