/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.enums.ViewingDirection;
import de.digitalcollections.iiif.model.interfaces.PageContainer;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Layer
extends Resource<Layer>
implements PageContainer<AnnotationList> {
    public static final String TYPE = "sc:Layer";
    private ViewingDirection viewingDirection;
    @JsonProperty(value="first")
    private AnnotationList firstAnnotationPage;
    @JsonProperty(value="last")
    private AnnotationList lastAnnotationPage;
    @JsonProperty(value="total")
    private Integer totalAnnotations;
    private List<AnnotationList> otherContent;

    @JsonCreator
    public Layer(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    public Layer(String identifier, String label) {
        super(identifier);
        this.addLabel(label, new String[0]);
    }

    public Layer() {
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public ViewingDirection getViewingDirection() {
        return this.viewingDirection;
    }

    public void setViewingDirection(ViewingDirection viewingDirection) {
        this.viewingDirection = viewingDirection;
    }

    public List<AnnotationList> getOtherContent() {
        return this.otherContent;
    }

    public void setOtherContent(List<AnnotationList> otherContent) {
        this.otherContent = otherContent;
    }

    public Layer addOtherContent(String first, String ... rest) {
        return this.addOtherContent(new AnnotationList(first), (AnnotationList[])Arrays.stream(rest).map(AnnotationList::new).toArray(AnnotationList[]::new));
    }

    public Layer addOtherContent(AnnotationList first, AnnotationList ... rest) {
        if (this.otherContent == null) {
            this.otherContent = new ArrayList<AnnotationList>();
        }
        this.otherContent.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    @Override
    public AnnotationList getFirst() {
        return this.firstAnnotationPage;
    }

    @Override
    public void setFirst(AnnotationList first) {
        this.firstAnnotationPage = first;
    }

    @Override
    public AnnotationList getLast() {
        return this.lastAnnotationPage;
    }

    @Override
    public void setLast(AnnotationList last) {
        this.lastAnnotationPage = last;
    }

    @Override
    public Integer getTotal() {
        return this.totalAnnotations;
    }

    @Override
    public void setTotal(int total) {
        this.totalAnnotations = total;
    }
}

