/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.IndexedListSerializer;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;

public final class IiifIndexedListSerializer
extends AsArraySerializerBase<List<?>> {
    private static final ImmutableSet<String> UNWRAP_FIELDS = ImmutableSet.of((Object)"service", (Object)"profile", (Object)"within", (Object)"logo", (Object)"description", (Object)"viewingHint", (Object[])new String[]{"@type", "license", "rendering", "seeAlso", "related", "thumbnail"});
    private final IndexedListSerializer defaultSerializer;

    public IiifIndexedListSerializer(IndexedListSerializer defaultSerializer, TypeFactory tf) {
        super(List.class, tf.constructSimpleType(Object.class, new JavaType[0]), false, null, null);
        this.defaultSerializer = defaultSerializer;
    }

    private IiifIndexedListSerializer(IiifIndexedListSerializer src, BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSerializer, Boolean unwrapSingle) {
        super((AsArraySerializerBase)src, prop, vts, valueSerializer, unwrapSingle);
        this.defaultSerializer = src.defaultSerializer;
    }

    public AsArraySerializerBase<List<?>> withResolved(BeanProperty property, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new IiifIndexedListSerializer(this, property, vts, elementSerializer, unwrapSingle);
    }

    public final void serialize(List<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.size();
        String currentName = gen.getOutputContext().getCurrentName();
        if (UNWRAP_FIELDS.contains((Object)currentName) && len == 1) {
            this.defaultSerializer.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray(len);
        if (!value.isEmpty()) {
            this.defaultSerializer.serializeContents(value, gen, provider);
        }
        gen.writeEndArray();
    }

    protected void serializeContents(List<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.defaultSerializer.serializeContents(value, gen, provider);
    }

    public boolean hasSingleElement(List<?> value) {
        return this.defaultSerializer.hasSingleElement(value);
    }

    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this.defaultSerializer._withValueTypeSerializer(vts);
    }
}

