/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.image;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.PropertyValue;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.Size;
import de.digitalcollections.iiif.model.image.TileInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ImageService
extends Service {
    @JsonProperty(value="protocol")
    public final String PROTOCOL = "http://iiif.io/api/image";
    @JsonProperty(value="@context")
    public static final String CONTEXT = "http://iiif.io/api/image/2/context.json";
    private Integer width;
    private Integer height;
    private List<TileInfo> tiles;
    private List<Size> sizes;
    @JsonProperty(value="service")
    private List<Service> services;
    @JsonProperty(value="attribution")
    private PropertyValue attribution;
    @JsonProperty(value="license")
    private List<URI> licenses;
    @JsonProperty(value="logo")
    private List<ImageContent> logos;

    @JsonCreator
    public ImageService(@JsonProperty(value="@id") String identifier) {
        super(URI.create(CONTEXT));
        this.setIdentifier(URI.create(identifier));
    }

    public ImageService(String identifier, ImageApiProfile profile) {
        this(identifier);
        this.addProfile(profile, new Profile[0]);
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public List<TileInfo> getTiles() {
        return this.tiles;
    }

    public void setTiles(List<TileInfo> tiles) {
        this.tiles = tiles;
    }

    public ImageService addTile(TileInfo first, TileInfo ... rest) {
        if (this.tiles == null) {
            this.tiles = new ArrayList<TileInfo>();
        }
        this.tiles.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<Size> getSizes() {
        return this.sizes;
    }

    public void setSizes(List<Size> sizes) {
        this.sizes = sizes;
    }

    public ImageService addSize(Size first, Size ... rest) {
        if (this.sizes == null) {
            this.sizes = new ArrayList<Size>();
        }
        this.sizes.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public ImageService addService(Service first, Service ... rest) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public PropertyValue getAttribution() {
        return this.attribution;
    }

    @JsonIgnore
    public String getAttributionString() {
        return this.attribution.getFirstValue();
    }

    public void setAttribution(PropertyValue attribution) {
        this.attribution = attribution;
    }

    public ImageService addAttribution(String first, String ... rest) {
        if (this.attribution == null) {
            this.attribution = new PropertyValue();
        }
        this.attribution.addValue(first, rest);
        return this;
    }

    public List<URI> getLicenses() {
        return this.licenses;
    }

    @JsonIgnore
    public URI getFirstLicense() {
        if (this.licenses == null || this.licenses.isEmpty()) {
            return null;
        }
        return this.licenses.get(0);
    }

    public void setLicenses(List<URI> licenses) {
        this.licenses = licenses;
    }

    public ImageService addLicense(String first, String ... rest) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<URI>();
        }
        this.licenses.add(URI.create(first));
        Arrays.stream(rest).map(URI::create).forEach(this.licenses::add);
        return this;
    }

    public List<ImageContent> getLogos() {
        return this.logos;
    }

    @JsonIgnore
    public URI getLogoUri() {
        if (this.logos == null || this.logos.isEmpty()) {
            return null;
        }
        return this.logos.get(0).getIdentifier();
    }

    public void setLogos(List<ImageContent> logos) {
        this.logos = logos;
    }

    public ImageService addLogo(String first, String ... rest) {
        if (this.logos == null) {
            this.logos = new ArrayList<ImageContent>();
        }
        this.logos.add(new ImageContent(first));
        Arrays.stream(rest).map(ImageContent::new).forEach(this.logos::add);
        return this;
    }

    public ImageService addLogo(ImageContent first, ImageContent ... rest) {
        if (this.logos == null) {
            this.logos = new ArrayList<ImageContent>();
        }
        this.logos.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }
}

